/**
* EaselJS
* Visit http://easeljs.com/ for documentation, updates and examples.
*
* Copyright (c) 2011 Grant Skinner
*
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
**/
(function(j){var c=function(){throw"UID cannot be instantiated";};c._nextID=0;c.get=function(){return c._nextID++};j.UID=c})(window);(function(j){var c=function(){throw"Ticker cannot be instantiated.";};c.useRAF=null;c.animationTarget=null;c._listeners=null;c._pauseable=null;c._paused=false;c._inited=false;c._startTime=0;c._pausedTime=0;c._ticks=0;c._pausedTickers=0;c._interval=50;c._lastTime=0;c._times=null;c._tickTimes=null;c._rafActive=false;c._timeoutID=null;c.addListener=function(a,b){a!=null&&(c._inited||c.init(),c.removeListener(a),c._pauseable[c._listeners.length]=b==null?true:b,c._listeners.push(a))};c.init=function(){c._inited=
true;c._times=[];c._tickTimes=[];c._pauseable=[];c._listeners=[];c._times.push(c._lastTime=c._startTime=c._getTime());c.setInterval(c._interval)};c.removeListener=function(a){c._listeners!=null&&(a=c._listeners.indexOf(a),a!=-1&&(c._listeners.splice(a,1),c._pauseable.splice(a,1)))};c.removeAllListeners=function(){c._listeners=[];c._pauseable=[]};c.setInterval=function(a){c._interval=a;c._inited&&c._setupTick()};c.getInterval=function(){return c._interval};c.setFPS=function(a){c.setInterval(1E3/a)};
c.getFPS=function(){return 1E3/c._interval};c.getMeasuredFPS=function(a){if(c._times.length<2)return-1;a==null&&(a=c.getFPS()|0);a=Math.min(c._times.length-1,a);return 1E3/((c._times[0]-c._times[a])/a)};c.setPaused=function(a){c._paused=a};c.getPaused=function(){return c._paused};c.getTime=function(a){return c._getTime()-c._startTime-(a?c._pausedTime:0)};c.getTicks=function(a){return c._ticks-(a?c._pausedTickers:0)};c._handleAF=function(a){a-c._lastTime>=c._interval-1&&c._tick();c._rafActive=false;
c._setupTick()};c._handleTimeout=function(){c._tick();c.timeoutID=null;c._setupTick()};c._setupTick=function(){if(!(c._rafActive||c.timeoutID!=null)){if(c.useRAF){var a=j.requestAnimationFrame||j.webkitRequestAnimationFrame||j.mozRequestAnimationFrame||j.oRequestAnimationFrame||j.msRequestAnimationFrame;if(a){a(c._handleAF,c.animationTarget);c._rafActive=true;return}}c.timeoutID=setTimeout(c._handleTimeout,c._interval)}};c._tick=function(){c._ticks++;var a=c._getTime(),b=a-c._lastTime,p=c._paused;
p&&(c._pausedTickers++,c._pausedTime+=b);c._lastTime=a;for(var i=c._pauseable,d=c._listeners.slice(),e=d?d.length:0,f=0;f<e;f++){var g=d[f];g==null||p&&i[f]||(g.tick?g.tick(b,p):g instanceof Function&&g(b,p))}for(c._tickTimes.unshift(c._getTime()-a);c._tickTimes.length>100;)c._tickTimes.pop();for(c._times.unshift(a);c._times.length>100;)c._times.pop()};c._getTime=function(){return(new Date).getTime()};j.Ticker=c})(window);(function(j){var c=function(b,a,i,c,e){this.initialize(b,a,i,c,e)},a=c.prototype;a.stageX=0;a.stageY=0;a.type=null;a.nativeEvent=null;a.onMouseMove=null;a.onMouseUp=null;a.target=null;a.initialize=function(b,a,i,c,e){this.type=b;this.stageX=a;this.stageY=i;this.target=c;this.nativeEvent=e};a.clone=function(){return new c(this.type,this.stageX,this.stageY,this.target,this.nativeEvent)};a.toString=function(){return"[MouseEvent (type="+this.type+" stageX="+this.stageX+" stageY="+this.stageY+")]"};j.MouseEvent=
c})(window);(function(j){var c=function(b,a,i,c,e,f){this.initialize(b,a,i,c,e,f)},a=c.prototype;c.identity=null;c.DEG_TO_RAD=Math.PI/180;a.a=1;a.b=0;a.c=0;a.d=1;a.tx=0;a.ty=0;a.alpha=1;a.shadow=null;a.compositeOperation=null;a.initialize=function(b,a,i,c,e,f){if(b!=null)this.a=b;this.b=a||0;this.c=i||0;if(c!=null)this.d=c;this.tx=e||0;this.ty=f||0};a.prepend=function(b,a,i,c,e,f){var g=this.tx;if(b!=1||a!=0||i!=0||c!=1){var k=this.a,h=this.c;this.a=k*b+this.b*i;this.b=k*a+this.b*c;this.c=h*b+this.d*i;this.d=
h*a+this.d*c}this.tx=g*b+this.ty*i+e;this.ty=g*a+this.ty*c+f};a.append=function(b,a,i,c,e,f){var g=this.a,k=this.b,h=this.c,l=this.d;this.a=b*g+a*h;this.b=b*k+a*l;this.c=i*g+c*h;this.d=i*k+c*l;this.tx=e*g+f*h+this.tx;this.ty=e*k+f*l+this.ty};a.prependMatrix=function(b){this.prepend(b.a,b.b,b.c,b.d,b.tx,b.ty);this.prependProperties(b.alpha,b.shadow,b.compositeOperation)};a.appendMatrix=function(b){this.append(b.a,b.b,b.c,b.d,b.tx,b.ty);this.appendProperties(b.alpha,b.shadow,b.compositeOperation)};
a.prependTransform=function(b,a,i,d,e,f,g,k,h){if(e%360)var l=e*c.DEG_TO_RAD,e=Math.cos(l),l=Math.sin(l);else e=1,l=0;if(k||h)this.tx-=k,this.ty-=h;f||g?(f*=c.DEG_TO_RAD,g*=c.DEG_TO_RAD,this.prepend(e*i,l*i,-l*d,e*d,0,0),this.prepend(Math.cos(g),Math.sin(g),-Math.sin(f),Math.cos(f),b,a)):this.prepend(e*i,l*i,-l*d,e*d,b,a)};a.appendTransform=function(b,a,i,d,e,f,g,k,h){if(e%360)var l=e*c.DEG_TO_RAD,e=Math.cos(l),l=Math.sin(l);else e=1,l=0;f||g?(f*=c.DEG_TO_RAD,g*=c.DEG_TO_RAD,this.append(Math.cos(g),
Math.sin(g),-Math.sin(f),Math.cos(f),b,a),this.append(e*i,l*i,-l*d,e*d,0,0)):this.append(e*i,l*i,-l*d,e*d,b,a);if(k||h)this.tx-=k*this.a+h*this.c,this.ty-=k*this.b+h*this.d};a.rotate=function(b){var a=Math.cos(b),b=Math.sin(b),i=this.a,c=this.c,e=this.tx;this.a=i*a-this.b*b;this.b=i*b+this.b*a;this.c=c*a-this.d*b;this.d=c*b+this.d*a;this.tx=e*a-this.ty*b;this.ty=e*b+this.ty*a};a.skew=function(b,a){b*=c.DEG_TO_RAD;a*=c.DEG_TO_RAD;this.append(Math.cos(a),Math.sin(a),-Math.sin(b),Math.cos(b),0,0)};a.scale=
function(b,a){this.a*=b;this.d*=a;this.tx*=b;this.ty*=a};a.translate=function(b,a){this.tx+=b;this.ty+=a};a.identity=function(){this.alpha=this.a=this.d=1;this.b=this.c=this.tx=this.ty=0;this.shadow=this.compositeOperation=null};a.invert=function(){var b=this.a,a=this.b,i=this.c,c=this.d,e=this.tx,f=b*c-a*i;this.a=c/f;this.b=-a/f;this.c=-i/f;this.d=b/f;this.tx=(i*this.ty-c*e)/f;this.ty=-(b*this.ty-a*e)/f};a.isIdentity=function(){return this.tx==0&&this.ty==0&&this.a==1&&this.b==0&&this.c==0&&this.d==
1};a.decompose=function(b){b==null&&(b={});b.x=this.tx;b.y=this.ty;b.scaleX=Math.sqrt(this.a*this.a+this.b*this.b);b.scaleY=Math.sqrt(this.c*this.c+this.d*this.d);var a=Math.atan2(-this.c,this.d),i=Math.atan2(this.b,this.a);a==i?(b.rotation=i/c.DEG_TO_RAD,this.a<0&&this.d>=0&&(b.rotation+=b.rotation<=0?180:-180),b.skewX=b.skewY=0):(b.skewX=a/c.DEG_TO_RAD,b.skewY=i/c.DEG_TO_RAD);return b};a.reinitialize=function(b,a,i,c,e,f,g,k,h){this.initialize(b,a,i,c,e,f);this.alpha=g||1;this.shadow=k;this.compositeOperation=
h;return this};a.appendProperties=function(b,a,c){this.alpha*=b;this.shadow=a||this.shadow;this.compositeOperation=c||this.compositeOperation};a.prependProperties=function(b,a,c){this.alpha*=b;this.shadow=this.shadow||a;this.compositeOperation=this.compositeOperation||c};a.clone=function(){var b=new c(this.a,this.b,this.c,this.d,this.tx,this.ty);b.shadow=this.shadow;b.alpha=this.alpha;b.compositeOperation=this.compositeOperation;return b};a.toString=function(){return"[Matrix2D (a="+this.a+" b="+this.b+
" c="+this.c+" d="+this.d+" tx="+this.tx+" ty="+this.ty+")]"};c.identity=new c(1,0,0,1,0,0);j.Matrix2D=c})(window);(function(j){var c=function(b,a){this.initialize(b,a)},a=c.prototype;a.x=0;a.y=0;a.initialize=function(b,a){this.x=b==null?0:b;this.y=a==null?0:a};a.clone=function(){return new c(this.x,this.y)};a.toString=function(){return"[Point (x="+this.x+" y="+this.y+")]"};j.Point=c})(window);(function(j){var c=function(b,a,c,d){this.initialize(b,a,c,d)},a=c.prototype;a.x=0;a.y=0;a.width=0;a.height=0;a.initialize=function(b,a,c,d){this.x=b==null?0:b;this.y=a==null?0:a;this.width=c==null?0:c;this.height=d==null?0:d};a.clone=function(){return new c(this.x,this.y,this.width,this.height)};a.toString=function(){return"[Rectangle (x="+this.x+" y="+this.y+" width="+this.width+" height="+this.height+")]"};j.Rectangle=c})(window);(function(j){var c=function(b,a,c,d){this.initialize(b,a,c,d)},a=c.prototype;c.identity=null;a.color=null;a.offsetX=0;a.offsetY=0;a.blur=0;a.initialize=function(b,a,c,d){this.color=b;this.offsetX=a;this.offsetY=c;this.blur=d};a.toString=function(){return"[Shadow]"};a.clone=function(){return new c(this.color,this.offsetX,this.offsetY,this.blur)};c.identity=new c("transparent",0,0,0);j.Shadow=c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype;a.complete=true;a._animations=null;a._frames=null;a._images=null;a._data=null;a._loadCount=0;a._frameHeight=0;a._frameWidth=0;a._numFrames=0;a._regX=0;a._regY=0;a.initialize=function(b){var a,c,d;if(b!=null){if(b.images&&(c=b.images.length)>0){d=this._images=[];for(a=0;a<c;a++){var e=b.images[a];if(!(e instanceof Image)){var f=e,e=new Image;e.src=f}d.push(e);if(!e.getContext&&!e.complete)this._loadCount++,this.complete=false,function(b){e.onload=
function(){b._handleImageLoad()}}(this)}}if(b.frames!=null)if(b.frames instanceof Array){this._frames=[];d=b.frames;for(a=0,c=d.length;a<c;a++)f=d[a],this._frames.push({image:this._images[f[4]?f[4]:0],rect:new Rectangle(f[0],f[1],f[2],f[3]),regX:f[5]||0,regY:f[6]||0})}else c=b.frames,this._frameWidth=c.width,this._frameHeight=c.height,this._regX=c.regX||0,this._regY=c.regY||0,this._numFrames=c.count,this._loadCount==0&&this._calculateFrames();if((c=b.animations)!=null){this._animations=[];this._data=
{};for(var g in c){b={name:g};f=c[g];if(isNaN(f))if(f instanceof Array){b.frequency=f[3];b.next=f[2];d=b.frames=[];for(a=f[0];a<=f[1];a++)d.push(a)}else b.frequency=f.frequency,b.next=f.next,d=b.frames=f.frames.slice(0);else d=b.frames=[f];b.next=d.length<2||b.next==false?null:b.next==null||b.next==true?g:b.next;if(!b.frequency)b.frequency=1;this._animations.push(g);this._data[g]=b}}}};a.getNumFrames=function(b){return b==null?this._frames?this._frames.length:this._numFrames:(b=this._data[b],b==null?
0:b.frames.length)};a.getAnimations=function(){return this._animations.slice(0)};a.getAnimation=function(b){return this._data[b]};a.getFrame=function(b){return this.complete&&this._frames&&(frame=this._frames[b])?frame:null};a.toString=function(){return"[SpriteSheet]"};a.clone=function(){var b=new c;b.complete=this.complete;b._animations=this._animations;b._frames=this._frames;b._images=this._images;b._data=this._data;b._frameHeight=this._frameHeight;b._frameWidth=this._frameWidth;b._numFrames=this._numFrames;
b._loadCount=this._loadCount;return b};a._handleImageLoad=function(){if(--this._loadCount==0)this._calculateFrames(),this.complete=true};a._calculateFrames=function(){if(!(this._frames||this._frameWidth==0)){this._frames=[];for(var b=0,a=this._frameWidth,c=this._frameHeight,d=0,e=this._images;d<e.length;d++){for(var f=e[d],g=(f.width+1)/a|0,k=(f.height+1)/c|0,k=this._numFrames>0?Math.min(this._numFrames-b,g*k):g*k,h=0;h<k;h++)this._frames.push({image:f,rect:new Rectangle(h%g*a,(h/g|0)*c,a,c),regX:this._regX,
regY:this._regY});b+=k}this._numFrames=b}};j.SpriteSheet=c})(window);(function(j){function c(b,a){this.f=b;this.params=a}c.prototype.exec=function(b){this.f.apply(b,this.params)};var a=function(){this.initialize()},b=a.prototype;a.getRGB=function(b,a,c,e){b!=null&&c==null&&(e=a,c=b&255,a=b>>8&255,b=b>>16&255);return e==null?"rgb("+b+","+a+","+c+")":"rgba("+b+","+a+","+c+","+e+")"};a.getHSL=function(b,a,c,e){return e==null?"hsl("+b%360+","+a+"%,"+c+"%)":"hsla("+b%360+","+a+"%,"+c+"%,"+e+")"};a.BASE_64={A:0,B:1,C:2,D:3,E:4,F:5,G:6,H:7,I:8,J:9,K:10,L:11,M:12,N:13,O:14,
P:15,Q:16,R:17,S:18,T:19,U:20,V:21,W:22,X:23,Y:24,Z:25,a:26,b:27,c:28,d:29,e:30,f:31,g:32,h:33,i:34,j:35,k:36,l:37,m:38,n:39,o:40,p:41,q:42,r:43,s:44,t:45,u:46,v:47,w:48,x:49,y:50,z:51,0:52,1:53,2:54,3:55,4:56,5:57,6:58,7:59,8:60,9:61,"+":62,"/":63};a.STROKE_CAPS_MAP=["butt","round","square"];a.STROKE_JOINTS_MAP=["miter","round","bevel"];a._ctx=document.createElement("canvas").getContext("2d");a.beginCmd=new c(a._ctx.beginPath,[]);a.fillCmd=new c(a._ctx.fill,[]);a.strokeCmd=new c(a._ctx.stroke,[]);
b._strokeInstructions=null;b._strokeStyleInstructions=null;b._fillInstructions=null;b._instructions=null;b._oldInstructions=null;b._activeInstructions=null;b._active=false;b._dirty=false;b.initialize=function(){this.clear();this._ctx=a._ctx};b.draw=function(b){this._dirty&&this._updateInstructions();for(var a=this._instructions,c=0,e=a.length;c<e;c++)a[c].exec(b)};b.moveTo=function(b,a){this._activeInstructions.push(new c(this._ctx.moveTo,[b,a]));return this};b.lineTo=function(b,a){this._dirty=this._active=
true;this._activeInstructions.push(new c(this._ctx.lineTo,[b,a]));return this};b.arcTo=function(b,a,d,e,f){this._dirty=this._active=true;this._activeInstructions.push(new c(this._ctx.arcTo,[b,a,d,e,f]));return this};b.arc=function(b,a,d,e,f,g){this._dirty=this._active=true;g==null&&(g=false);this._activeInstructions.push(new c(this._ctx.arc,[b,a,d,e,f,g]));return this};b.quadraticCurveTo=function(b,a,d,e){this._dirty=this._active=true;this._activeInstructions.push(new c(this._ctx.quadraticCurveTo,
[b,a,d,e]));return this};b.bezierCurveTo=function(b,a,d,e,f,g){this._dirty=this._active=true;this._activeInstructions.push(new c(this._ctx.bezierCurveTo,[b,a,d,e,f,g]));return this};b.rect=function(b,a,d,e){this._dirty=this._active=true;this._activeInstructions.push(new c(this._ctx.rect,[b,a,d,e]));return this};b.closePath=function(){if(this._active)this._dirty=true,this._activeInstructions.push(new c(this._ctx.closePath,[]));return this};b.clear=function(){this._instructions=[];this._oldInstructions=
[];this._activeInstructions=[];this._strokeStyleInstructions=this._strokeInstructions=this._fillInstructions=null;this._active=this._dirty=false;return this};b.beginFill=function(b){this._active&&this._newPath();this._fillInstructions=b?[new c(this._setProp,["fillStyle",b])]:null;return this};b.beginLinearGradientFill=function(b,a,d,e,f,g){this._active&&this._newPath();d=this._ctx.createLinearGradient(d,e,f,g);e=0;for(f=b.length;e<f;e++)d.addColorStop(a[e],b[e]);this._fillInstructions=[new c(this._setProp,
["fillStyle",d])];return this};b.beginRadialGradientFill=function(b,a,d,e,f,g,k,h){this._active&&this._newPath();d=this._ctx.createRadialGradient(d,e,f,g,k,h);e=0;for(f=b.length;e<f;e++)d.addColorStop(a[e],b[e]);this._fillInstructions=[new c(this._setProp,["fillStyle",d])];return this};b.beginBitmapFill=function(b,a){this._active&&this._newPath();var d=this._ctx.createPattern(b,a||"");this._fillInstructions=[new c(this._setProp,["fillStyle",d])];return this};b.endFill=function(){this.beginFill();
return this};b.setStrokeStyle=function(b,i,d,e){this._active&&this._newPath();this._strokeStyleInstructions=[new c(this._setProp,["lineWidth",b==null?"1":b]),new c(this._setProp,["lineCap",i==null?"butt":isNaN(i)?i:a.STROKE_CAPS_MAP[i]]),new c(this._setProp,["lineJoin",d==null?"miter":isNaN(d)?d:a.STROKE_JOINTS_MAP[d]]),new c(this._setProp,["miterLimit",e==null?"10":e])];return this};b.beginStroke=function(b){this._active&&this._newPath();this._strokeInstructions=b?[new c(this._setProp,["strokeStyle",
b])]:null;return this};b.beginLinearGradientStroke=function(b,a,d,e,f,g){this._active&&this._newPath();d=this._ctx.createLinearGradient(d,e,f,g);e=0;for(f=b.length;e<f;e++)d.addColorStop(a[e],b[e]);this._strokeInstructions=[new c(this._setProp,["strokeStyle",d])];return this};b.beginRadialGradientStroke=function(b,a,d,e,f,g,k,h){this._active&&this._newPath();d=this._ctx.createRadialGradient(d,e,f,g,k,h);e=0;for(f=b.length;e<f;e++)d.addColorStop(a[e],b[e]);this._strokeInstructions=[new c(this._setProp,
["strokeStyle",d])];return this};b.beginBitmapStroke=function(b,a){this._active&&this._newPath();var d=this._ctx.createPattern(b,a||"");this._strokeInstructions=[new c(this._setProp,["strokeStyle",d])];return this};b.endStroke=function(){this.beginStroke();return this};b.curveTo=b.quadraticCurveTo;b.drawRect=b.rect;b.drawRoundRect=function(b,a,c,e,f){this.drawRoundRectComplex(b,a,c,e,f,f,f,f);return this};b.drawRoundRectComplex=function(b,a,d,e,f,g,k,h){this._dirty=this._active=true;var l=Math.PI,
j=this._ctx.arc,m=this._ctx.lineTo;this._activeInstructions.push(new c(this._ctx.moveTo,[b+f,a]),new c(m,[b+d-g,a]),g>=0?new c(j,[b+d-g,a+g,g,-l/2,0]):new c(j,[b+d,a,-g,l,l/2,true]),new c(m,[b+d,a+e-k]),h>=0?new c(j,[b+d-k,a+e-k,k,0,l/2]):new c(j,[b+d,a+e,-k,-l/2,l,true]),new c(m,[b+h,a+e]),h>=0?new c(j,[b+h,a+e-h,h,l/2,l]):new c(j,[b,a+e,-h,0,-l/2,true]),new c(m,[b,a+f]),f>=0?new c(j,[b+f,a+f,f,l,-l/2]):new c(j,[b,a,-f,l/2,0,true]));return this};b.drawCircle=function(b,a,c){this.arc(b,a,c,0,Math.PI*
2);return this};b.drawEllipse=function(b,a,d,e){this._dirty=this._active=true;var f=d/2*0.5522848,g=e/2*0.5522848,k=b+d,h=a+e,d=b+d/2,e=a+e/2;this._activeInstructions.push(new c(this._ctx.moveTo,[b,e]),new c(this._ctx.bezierCurveTo,[b,e-g,d-f,a,d,a]),new c(this._ctx.bezierCurveTo,[d+f,a,k,e-g,k,e]),new c(this._ctx.bezierCurveTo,[k,e+g,d+f,h,d,h]),new c(this._ctx.bezierCurveTo,[d-f,h,b,e+g,b,e]));return this};b.drawPolyStar=function(b,a,d,e,f,g){this._dirty=this._active=true;f==null&&(f=0);f=1-f;g==
null?g=0:g/=180/Math.PI;var k=Math.PI/e;this._activeInstructions.push(new c(this._ctx.moveTo,[b+Math.cos(g)*d,a+Math.sin(g)*d]));for(var h=0;h<e;h++)g+=k,f!=1&&this._activeInstructions.push(new c(this._ctx.lineTo,[b+Math.cos(g)*d*f,a+Math.sin(g)*d*f])),g+=k,this._activeInstructions.push(new c(this._ctx.lineTo,[b+Math.cos(g)*d,a+Math.sin(g)*d]));return this};b.p=b.decodePath=function(b){for(var c=[this.moveTo,this.lineTo,this.quadraticCurveTo,this.bezierCurveTo],d=[2,2,4,6],e=0,f=b.length,g=[],k=0,
h=0,l=a.BASE_64;e<f;){var j=l[b.charAt(e)],m=j>>3,q=c[m];if(!q||j&3)throw"bad path data";var r=d[m];m||(k=h=0);g.length=0;e++;j=(j>>2&1)+2;for(m=0;m<r;m++){var n=l[b.charAt(e)],s=n>>5?-1:1,n=(n&31)<<6|l[b.charAt(e+1)];j==3&&(n=n<<6|l[b.charAt(e+2)]);n=s*n/10;m%2?k=n+=k:h=n+=h;g[m]=n;e+=j}q.apply(this,g)}return this};b.clone=function(){var b=new a;b._instructions=this._instructions.slice();b._activeInstructions=this._activeInstructions.slice();b._oldInstructions=this._oldInstructions.slice();if(this._fillInstructions)b._fillInstructions=
this._fillInstructions.slice();if(this._strokeInstructions)b._strokeInstructions=this._strokeInstructions.slice();if(this._strokeStyleInstructions)b._strokeStyleInstructions=this._strokeStyleInstructions.slice();b._active=this._active;b._dirty=this._dirty;return b};b.toString=function(){return"[Graphics]"};b.mt=b.moveTo;b.lt=b.lineTo;b.at=b.arcTo;b.bt=b.bezierCurveTo;b.qt=b.quadraticCurveTo;b.a=b.arc;b.r=b.rect;b.cp=b.closePath;b.c=b.clear;b.f=b.beginFill;b.lf=b.beginLinearGradientFill;b.rf=b.beginRadialGradientFill;
b.bf=b.beginBitmapFill;b.ef=b.endFill;b.ss=b.setStrokeStyle;b.s=b.beginStroke;b.ls=b.beginLinearGradientStroke;b.rs=b.beginRadialGradientStroke;b.bs=b.beginBitmapStroke;b.es=b.endStroke;b.dr=b.drawRect;b.rr=b.drawRoundRect;b.rc=b.drawRoundRectComplex;b.dc=b.drawCircle;b.de=b.drawEllipse;b.dp=b.drawPolyStar;b._updateInstructions=function(){this._instructions=this._oldInstructions.slice();this._instructions.push(a.beginCmd);this._fillInstructions&&this._instructions.push.apply(this._instructions,this._fillInstructions);
this._strokeInstructions&&(this._instructions.push.apply(this._instructions,this._strokeInstructions),this._strokeStyleInstructions&&this._instructions.push.apply(this._instructions,this._strokeStyleInstructions));this._instructions.push.apply(this._instructions,this._activeInstructions);this._fillInstructions&&this._instructions.push(a.fillCmd);this._strokeInstructions&&this._instructions.push(a.strokeCmd)};b._newPath=function(){this._dirty&&this._updateInstructions();this._oldInstructions=this._instructions;
this._activeInstructions=[];this._active=this._dirty=false};b._setProp=function(b,a){this[b]=a};j.Graphics=a})(window);(function(j){var c=function(){this.initialize()},a=c.prototype;c.suppressCrossDomainErrors=false;c._hitTestCanvas=document.createElement("canvas");c._hitTestCanvas.width=c._hitTestCanvas.height=1;c._hitTestContext=c._hitTestCanvas.getContext("2d");c._nextCacheID=1;a.alpha=1;a.cacheCanvas=null;a.id=-1;a.mouseEnabled=true;a.name=null;a.parent=null;a.regX=0;a.regY=0;a.rotation=0;a.scaleX=1;a.scaleY=1;a.skewX=0;a.skewY=0;a.shadow=null;a.visible=true;a.x=0;a.y=0;a.compositeOperation=null;a.snapToPixel=
false;a.onPress=null;a.onClick=null;a.onDoubleClick=null;a.onMouseOver=null;a.onMouseOut=null;a.tick=null;a.filters=null;a.cacheID=0;a._cacheOffsetX=0;a._cacheOffsetY=0;a._cacheDataURLID=0;a._cacheDataURL=null;a._matrix=null;a.initialize=function(){this.id=UID.get();this._matrix=new Matrix2D};a.isVisible=function(){return this.visible&&this.alpha>0&&this.scaleX!=0&&this.scaleY!=0};a.draw=function(b,a){if(a||!this.cacheCanvas)return false;b.drawImage(this.cacheCanvas,this._cacheOffsetX,this._cacheOffsetY);
return true};a.cache=function(b,a,i,d){if(this.cacheCanvas==null)this.cacheCanvas=document.createElement("canvas");var e=this.cacheCanvas.getContext("2d");this.cacheCanvas.width=i;this.cacheCanvas.height=d;e.clearRect(0,0,i+1,d+1);e.setTransform(1,0,0,1,-b,-a);this.draw(e,true,this._matrix.reinitialize(1,0,0,1,-b,-a));this._cacheOffsetX=b;this._cacheOffsetY=a;this._applyFilters();this.cacheID=c._nextCacheID++};a.updateCache=function(b){if(this.cacheCanvas==null)throw"cache() must be called before updateCache()";
var a=this.cacheCanvas.getContext("2d");a.setTransform(1,0,0,1,-this._cacheOffsetX,-this._cacheOffsetY);b?a.globalCompositeOperation=b:a.clearRect(0,0,this.cacheCanvas.width+1,this.cacheCanvas.height+1);this.draw(a,true);if(b)a.globalCompositeOperation="source-over";this._applyFilters();this.cacheID=c._nextCacheID++};a.uncache=function(){this._cacheDataURL=this.cacheCanvas=null;this.cacheID=this._cacheOffsetX=this._cacheOffsetY=0};a.getCacheDataURL=function(){if(!this.cacheCanvas)return null;if(this.cacheID!=
this._cacheDataURLID)this._cacheDataURL=this.cacheCanvas.toDataURL();return this._cacheDataURL};a.getStage=function(){for(var b=this;b.parent;)b=b.parent;return b instanceof Stage?b:null};a.localToGlobal=function(b,a){var c=this.getConcatenatedMatrix(this._matrix);if(c==null)return null;c.append(1,0,0,1,b,a);return new Point(c.tx,c.ty)};a.globalToLocal=function(b,a){var c=this.getConcatenatedMatrix(this._matrix);if(c==null)return null;c.invert();c.append(1,0,0,1,b,a);return new Point(c.tx,c.ty)};
a.localToLocal=function(b,a,c){b=this.localToGlobal(b,a);return c.globalToLocal(b.x,b.y)};a.setTransform=function(b,a,c,d,e,f,g,k,h){this.x=b||0;this.y=a||0;this.scaleX=c==null?1:c;this.scaleY=d==null?1:d;this.rotation=e||0;this.skewX=f||0;this.skewY=g||0;this.regX=k||0;this.regY=h||0};a.getConcatenatedMatrix=function(b){b?b.identity():b=new Matrix2D;for(var a=this;a!=null;)b.prependTransform(a.x,a.y,a.scaleX,a.scaleY,a.rotation,a.skewX,a.skewY,a.regX,a.regY),b.prependProperties(a.alpha,a.shadow,
a.compositeOperation),a=a.parent;return b};a.hitTest=function(b,a){var i=c._hitTestContext,d=c._hitTestCanvas;i.setTransform(1,0,0,1,-b,-a);this.draw(i);i=this._testHit(i);d.width=0;d.width=1;return i};a.clone=function(){var b=new c;this.cloneProps(b);return b};a.toString=function(){return"[DisplayObject (name="+this.name+")]"};a.cloneProps=function(b){b.alpha=this.alpha;b.name=this.name;b.regX=this.regX;b.regY=this.regY;b.rotation=this.rotation;b.scaleX=this.scaleX;b.scaleY=this.scaleY;b.shadow=
this.shadow;b.skewX=this.skewX;b.skewY=this.skewY;b.visible=this.visible;b.x=this.x;b.y=this.y;b.mouseEnabled=this.mouseEnabled;b.compositeOperation=this.compositeOperation;if(this.cacheCanvas)b.cacheCanvas=this.cacheCanvas.cloneNode(true),b.cacheCanvas.getContext("2d").putImageData(this.cacheCanvas.getContext("2d").getImageData(0,0,this.cacheCanvas.width,this.cacheCanvas.height),0,0)};a.applyShadow=function(b,a){a=a||Shadow.identity;b.shadowColor=a.color;b.shadowOffsetX=a.offsetX;b.shadowOffsetY=
a.offsetY;b.shadowBlur=a.blur};a._tick=function(b){if(this.onTick)this.onTick(b)};a._testHit=function(b){try{var a=b.getImageData(0,0,1,1).data[3]>1}catch(i){if(!c.suppressCrossDomainErrors)throw"An error has occured. This is most likely due to security restrictions on reading canvas pixel data with local or cross-domain images.";}return a};a._applyFilters=function(){if(this.filters&&this.filters.length!=0&&this.cacheCanvas)for(var b=this.filters.length,a=this.cacheCanvas.getContext("2d"),c=this.cacheCanvas.width,
d=this.cacheCanvas.height,e=0;e<b;e++)this.filters[e].applyFilter(a,0,0,c,d)};j.DisplayObject=c})(window);(function(j){var c=function(){this.initialize()},a=c.prototype=new DisplayObject;a.children=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(){this.DisplayObject_initialize();this.children=[]};a.isVisible=function(){return this.visible&&this.alpha>0&&this.children.length&&this.scaleX!=0&&this.scaleY!=0};a.DisplayObject_draw=a.draw;a.draw=function(b,a,i){var d=Stage._snapToPixelEnabled;if(this.DisplayObject_draw(b,a))return true;for(var i=i||this._matrix.reinitialize(1,0,0,1,0,0,
this.alpha,this.shadow,this.compositeOperation),a=this.children.length,e=this.children.slice(0),f=0;f<a;f++){var g=e[f];if(g.isVisible()){var k=false,h=g._matrix.reinitialize(i.a,i.b,i.c,i.d,i.tx,i.ty,i.alpha,i.shadow,i.compositeOperation);h.appendTransform(g.x,g.y,g.scaleX,g.scaleY,g.rotation,g.skewX,g.skewY,g.regX,g.regY);h.appendProperties(g.alpha,g.shadow,g.compositeOperation);if(!(g instanceof c&&g.cacheCanvas==null))d&&g.snapToPixel&&h.a==1&&h.b==0&&h.c==0&&h.d==1?b.setTransform(h.a,h.b,h.c,
h.d,h.tx+0.5|0,h.ty+0.5|0):b.setTransform(h.a,h.b,h.c,h.d,h.tx,h.ty),b.globalAlpha=h.alpha,b.globalCompositeOperation=h.compositeOperation||"source-over",(k=h.shadow)&&this.applyShadow(b,k);g.draw(b,false,h);k&&this.applyShadow(b)}}return true};a.addChild=function(b){if(b==null)return b;var a=arguments.length;if(a>1){for(var c=0;c<a;c++)this.addChild(arguments[c]);return arguments[a-1]}b.parent&&b.parent.removeChild(b);b.parent=this;this.children.push(b);return b};a.addChildAt=function(b,a){var c=
arguments.length;if(c>2){for(var a=arguments[d-1],d=0;d<c-1;d++)this.addChildAt(arguments[d],a+d);return arguments[c-2]}b.parent&&b.parent.removeChild(b);b.parent=this;this.children.splice(a,0,b);return b};a.removeChild=function(b){var a=arguments.length;if(a>1){for(var c=true,d=0;d<a;d++)c=c&&this.removeChild(arguments[d]);return c}return this.removeChildAt(this.children.indexOf(b))};a.removeChildAt=function(b){var a=arguments.length;if(a>1){for(var c=[],d=0;d<a;d++)c[d]=arguments[d];c.sort(function(b,
a){return a-b});for(var e=true,d=0;d<a;d++)e=e&&this.removeChildAt(c[d]);return e}if(b<0||b>this.children.length-1)return false;a=this.children[b];if(a!=null)a.parent=null;this.children.splice(b,1);return true};a.removeAllChildren=function(){for(var b=this.children;b.length;)b.pop().parent=null};a.getChildAt=function(b){return this.children[b]};a.sortChildren=function(b){this.children.sort(b)};a.getChildIndex=function(b){return this.children.indexOf(b)};a.getNumChildren=function(){return this.children.length};
a.swapChildrenAt=function(b,a){var c=this.children,d=c[b],e=c[a];d&&e&&(c[b]=e,c[a]=d)};a.swapChildren=function(b,a){for(var c=this.children,d,e,f=0,g=c.length;f<g;f++)if(c[f]==b&&(d=f),c[f]==a&&(e=f),d!=null&&e!=null)return;f!=g&&(c[d]=a,c[e]=b)};a.setChildIndex=function(b,a){for(var c=this.children,d=0,e=c.length;d<e;d++)if(c[d]==b)break;d==e||a<0||a>e||d==a||(c.splice(a,1),a<d&&d--,c.splice(b,d,0))};a.contains=function(b){for(;b;){if(b==this)return true;b=b.parent}return false};a.hitTest=function(b,
a){return this.getObjectUnderPoint(b,a)!=null};a.getObjectsUnderPoint=function(b,a){var c=[],d=this.localToGlobal(b,a);this._getObjectsUnderPoint(d.x,d.y,c);return c};a.getObjectUnderPoint=function(b,a){var c=this.localToGlobal(b,a);return this._getObjectsUnderPoint(c.x,c.y)};a.clone=function(b){var a=new c;this.cloneProps(a);if(b)for(var i=a.children=[],d=0,e=this.children.length;d<e;d++){var f=this.children[d].clone(b);f.parent=a;i.push(f)}return a};a.toString=function(){return"[Container (name="+
this.name+")]"};a._tick=function(b){for(var a=this.children.length-1;a>=0;a--){var c=this.children[a];c._tick&&c._tick(b)}if(this.onTick)this.onTick(b)};a._getObjectsUnderPoint=function(b,a,i,d){var e=DisplayObject._hitTestContext,f=DisplayObject._hitTestCanvas,g=this._matrix,k=d&1&&(this.onPress||this.onClick||this.onDoubleClick)||d&2&&(this.onMouseOver||this.onMouseOut);if(this.cacheCanvas)if(this.getConcatenatedMatrix(g),e.setTransform(g.a,g.b,g.c,g.d,g.tx-b,g.ty-a),e.globalAlpha=g.alpha,this.draw(e),
this._testHit(e)){if(f.width=0,f.width=1,k)return this}else return null;for(var h=this.children.length-1;h>=0;h--){var l=this.children[h];if(l.isVisible()&&l.mouseEnabled)if(l instanceof c)if(k){if(l=l._getObjectsUnderPoint(b,a))return this}else{if(l=l._getObjectsUnderPoint(b,a,i,d),!i&&l)return l}else if(!d||k||d&1&&(l.onPress||l.onClick||l.onDoubleClick)||d&2&&(l.onMouseOver||l.onMouseOut))if(l.getConcatenatedMatrix(g),e.setTransform(g.a,g.b,g.c,g.d,g.tx-b,g.ty-a),e.globalAlpha=g.alpha,l.draw(e),
this._testHit(e))if(f.width=0,f.width=1,k)return this;else if(i)i.push(l);else return l}return null};j.Container=c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype=new Container;c._snapToPixelEnabled=false;a.autoClear=true;a.canvas=null;a.mouseX=null;a.mouseY=null;a.onMouseMove=null;a.onMouseUp=null;a.onMouseDown=null;a.snapToPixelEnabled=false;a.mouseInBounds=false;a.tickOnUpdate=true;a._activeMouseEvent=null;a._activeMouseTarget=null;a._mouseOverIntervalID=null;a._mouseOverX=0;a._mouseOverY=0;a._mouseOverTarget=null;a.Container_initialize=a.initialize;
a.isTouchSupported = function(j) {
        return "ontouchstart" in j
    };
a.initialize=function(b){this.Container_initialize();
		this.canvas=b instanceof HTMLCanvasElement? b:document.getElementById(b);
		// HACK na Androida - od wersji 4 zdarzenia desktopowe oraz mobilne przychodza po sobie
        if(!this.isTouchSupported(this.canvas)){
        	this._enableMouseEvents(true);
    	}
		this._enableAttacheReattacheMonitor(this.canvas);
	};
a.isAnimationDisabled = false;
a._enableAttacheReattacheMonitor = function(canvas){
            var thiss = this;
            canvas.resumeAnimation =  function(){
				thiss.isAnimationDisabled = false;
			};
            canvas.pauseAnimation =  function(){
				thiss.isAnimationDisabled = true;
			};
	}

a.update=function(b){
	if(!this.isAnimationDisabled && this.canvas)
			this.autoClear&&this.clear(),c._snapToPixelEnabled=this.snapToPixelEnabled,this.tickOnUpdate&&this._tick(b),this.draw(this.canvas.getContext("2d"),false,this.getConcatenatedMatrix(this._matrix))
	}
	;a.tick=a.update;
	a.clear=function() {
		if (this.canvas) {
			var b=this.canvas.getContext("2d");
			b.setTransform(1,0,0,1,0,0);
			b.clearRect(0,0,this.canvas.width,this.canvas.height);
			// HACK na Androida - bez tego canvas zle sie mierzy na niektorych wersjach systemu
			if (navigator.userAgent.match(/android/ig)) {
				this.canvas.width = this.canvas.width;
			}
		}
	};
a.toDataURL=function(b,a){a||(a="image/png");var c=this.canvas.getContext("2d"),d=this.canvas.width,e=this.canvas.height,f;if(b){f=c.getImageData(0,0,d,e);var g=c.globalCompositeOperation;c.globalCompositeOperation="destination-over";c.fillStyle=b;c.fillRect(0,0,d,e)}var k=this.canvas.toDataURL(a);if(b)c.clearRect(0,0,d,e),c.putImageData(f,0,0),c.globalCompositeOperation=g;return k};a.enableMouseOver=function(b){if(this._mouseOverIntervalID)clearInterval(this._mouseOverIntervalID),this._mouseOverIntervalID=
null;if(b==null)b=20;else if(b<=0)return;var a=this;this._mouseOverIntervalID=setInterval(function(){a._testMouseOver()},1E3/Math.min(50,b));this._mouseOverX=NaN;this._mouseOverTarget=null};a.clone=function(){var b=new c(null);this.cloneProps(b);return b};a.toString=function(){return"[Stage (name="+this.name+")]"};a._enableMouseEvents=function(){var b=this,a=j.addEventListener?j:document;a.addEventListener("mouseup",function(a){b._handleMouseUp(a)},false);a.addEventListener("mousemove",function(a){b._handleMouseMove(a)},
false);a.addEventListener("dblclick",function(a){b._handleDoubleClick(a)},false);this.canvas&&this.canvas.addEventListener("mousedown",function(a){b._handleMouseDown(a)},false)};a._handleMouseMove=function(b){if(this.canvas){if(!b)b=j.event;var a=this.mouseInBounds;this._updateMousePosition(b.pageX,b.pageY);if(a||this.mouseInBounds){b=new MouseEvent("onMouseMove",this.mouseX,this.mouseY,this,b);if(this.onMouseMove)this.onMouseMove(b);if(this._activeMouseEvent&&this._activeMouseEvent.onMouseMove)this._activeMouseEvent.onMouseMove(b)}}else this.mouseX=
this.mouseY=null};a._updateMousePosition=function(b,a){var c=this.canvas;
	do{
	if(!!c.customOffsetLeft){
		b-=c.customOffsetLeft;
	}else{
	   b-=c.offsetLeft;
	}
	 a-=c.offsetTop;
	}while(c=c.offsetParent);if(this.mouseInBounds=b>=0&&a>=0&&b<this.canvas.width&&a<this.canvas.height)this.mouseX=b,this.mouseY=a};a._handleMouseUp=function(b){var a=new MouseEvent("onMouseUp",this.mouseX,this.mouseY,this,b);if(this.onMouseUp)this.onMouseUp(a);if(this._activeMouseEvent&&this._activeMouseEvent.onMouseUp)this._activeMouseEvent.onMouseUp(a);if(this._activeMouseTarget&&this._activeMouseTarget.onClick&&
this._getObjectsUnderPoint(this.mouseX,this.mouseY,null,true,this._mouseOverIntervalID?3:1)==this._activeMouseTarget)this._activeMouseTarget.onClick(new MouseEvent("onClick",this.mouseX,this.mouseY,this._activeMouseTarget,b));this._activeMouseEvent=this._activeMouseTarget=null};a._handleMouseDown=function(b){if(this.onMouseDown)this.onMouseDown(new MouseEvent("onMouseDown",this.mouseX,this.mouseY,this,b));var a=this._getObjectsUnderPoint(this.mouseX,this.mouseY,null,this._mouseOverIntervalID?3:1);
if(a){if(a.onPress instanceof Function&&(b=new MouseEvent("onPress",this.mouseX,this.mouseY,a,b),a.onPress(b),b.onMouseMove||b.onMouseUp))this._activeMouseEvent=b;this._activeMouseTarget=a}};a._testMouseOver=function(){if(!(this.mouseX==this._mouseOverX&&this.mouseY==this._mouseOverY&&this.mouseInBounds)){var b=null;if(this.mouseInBounds)b=this._getObjectsUnderPoint(this.mouseX,this.mouseY,null,3),this._mouseOverX=this.mouseX,this._mouseOverY=this.mouseY;if(this._mouseOverTarget!=b){if(this._mouseOverTarget&&
this._mouseOverTarget.onMouseOut)this._mouseOverTarget.onMouseOut(new MouseEvent("onMouseOut",this.mouseX,this.mouseY,this._mouseOverTarget));if(b&&b.onMouseOver)b.onMouseOver(new MouseEvent("onMouseOver",this.mouseX,this.mouseY,b));this._mouseOverTarget=b}}};a._handleDoubleClick=function(b){if(this.onDoubleClick)this.onDoubleClick(new MouseEvent("onDoubleClick",this.mouseX,this.mouseY,this,b));var a=this._getObjectsUnderPoint(this.mouseX,this.mouseY,null,this._mouseOverIntervalID?3:1);if(a&&a.onDoubleClick instanceof
Function)a.onDoubleClick(new MouseEvent("onPress",this.mouseX,this.mouseY,a,b))};j.Stage=c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype=new DisplayObject;a.image=null;a.snapToPixel=true;a.sourceRect=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(b){this.DisplayObject_initialize();typeof b=="string"?(this.image=new Image,this.image.src=b):this.image=b};a.isVisible=function(){return this.visible&&this.alpha>0&&this.scaleX!=0&&this.scaleY!=0&&this.image&&(this.image.complete||this.image.getContext||this.image.readyState>=2)};a.DisplayObject_draw=a.draw;
a.draw=function(b,a){if(this.DisplayObject_draw(b,a))return true;var c=this.sourceRect;c?b.drawImage(this.image,c.x,c.y,c.width,c.height,0,0,c.width,c.height):b.drawImage(this.image,0,0);return true};a.clone=function(){var b=new c(this.image);this.cloneProps(b);return b};a.toString=function(){return"[Bitmap (name="+this.name+")]"};j.Bitmap=c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype=new DisplayObject;a.onAnimationEnd=null;a.currentFrame=-1;a.currentAnimation=null;a.paused=true;a.spriteSheet=null;a.snapToPixel=true;a.offset=0;a.currentAnimationFrame=0;a._advanceCount=0;a._animation=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(b){this.DisplayObject_initialize();this.spriteSheet=b};a.isVisible=function(){return this.visible&&this.alpha>0&&this.scaleX!=0&&this.scaleY!=0&&this.spriteSheet.complete&&
this.currentFrame>=0};a.DisplayObject_draw=a.draw;a.draw=function(b,a){if(this.DisplayObject_draw(b,a))return true;this._normalizeFrame();var c=this.spriteSheet.getFrame(this.currentFrame);if(c!=null){var d=c.rect;b.drawImage(c.image,d.x,d.y,d.width,d.height,-c.regX,-c.regY,d.width,d.height);return true}};a.play=function(){this.paused=false};a.stop=function(){this.paused=true};a.gotoAndPlay=function(b){this.paused=false;this._goto(b)};a.gotoAndStop=function(b){this.paused=true;this._goto(b)};a.advance=
function(){this._animation?this.currentAnimationFrame++:this.currentFrame++;this._normalizeFrame()};a.clone=function(){var b=new c(this.spriteSheet);this.cloneProps(b);return b};a.toString=function(){return"[BitmapAnimation (name="+this.name+")]"};a._tick=function(b){var a=this._animation?this._animation.frequency:1;!this.paused&&(++this._advanceCount+this.offset)%a==0&&this.advance();if(this.onTick)this.onTick(b)};a._normalizeFrame=function(){var b=this._animation;if(b)if(this.currentAnimationFrame>=
b.frames.length){if(b.next?this._goto(b.next):(this.paused=true,this.currentAnimationFrame=b.frames.length-1,this.currentFrame=b.frames[this.currentAnimationFrame]),this.onAnimationEnd)this.onAnimationEnd(this,b.name)}else this.currentFrame=b.frames[this.currentAnimationFrame];else if(this.currentFrame>=this.spriteSheet.getNumFrames()&&(this.currentFrame=0,this.onAnimationEnd))this.onAnimationEnd(this,null)};a.DisplayObject_cloneProps=a.cloneProps;a.cloneProps=function(b){this.DisplayObject_cloneProps(b);
b.onAnimationEnd=this.onAnimationEnd;b.currentFrame=this.currentFrame;b.currentAnimation=this.currentAnimation;b.paused=this.paused;b.offset=this.offset;b._animation=this._animation;b.currentAnimationFrame=this.currentAnimationFrame};a._goto=function(b){if(isNaN(b)){var a=this.spriteSheet.getAnimation(b);if(a)this.currentAnimationFrame=0,this._animation=a,this.currentAnimation=b,this._normalizeFrame()}else this.currentAnimation=this._animation=null,this.currentFrame=b};j.BitmapAnimation=c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype=new DisplayObject;a.graphics=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(b){this.DisplayObject_initialize();this.graphics=b?b:new Graphics};a.isVisible=function(){return this.visible&&this.alpha>0&&this.scaleX!=0&&this.scaleY!=0&&this.graphics};a.DisplayObject_draw=a.draw;a.draw=function(b,a){if(this.DisplayObject_draw(b,a))return true;this.graphics.draw(b);return true};a.clone=function(b){b=new c(b&&this.graphics?
this.graphics.clone():this.graphics);this.cloneProps(b);return b};a.toString=function(){return"[Shape (name="+this.name+")]"};j.Shape=c})(window);(function(j){var c=function(b,a,c){this.initialize(b,a,c)},a=c.prototype=new DisplayObject;c._workingContext=document.createElement("canvas").getContext("2d");a.text="";a.font=null;a.color=null;a.textAlign=null;a.textBaseline=null;a.maxWidth=null;a.outline=false;a.lineHeight=null;a.lineWidth=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(b,a,c){this.DisplayObject_initialize();this.text=b;this.font=a;this.color=c?c:"#000"};a.isVisible=function(){return Boolean(this.visible&&this.alpha>
0&&this.scaleX!=0&&this.scaleY!=0&&this.text!=null&&this.text!="")};a.DisplayObject_draw=a.draw;a.draw=function(b,a){if(this.DisplayObject_draw(b,a))return true;this.outline?b.strokeStyle=this.color:b.fillStyle=this.color;b.font=this.font;b.textAlign=this.textAlign?this.textAlign:"start";b.textBaseline=this.textBaseline?this.textBaseline:"alphabetic";for(var c=String(this.text).split(/(?:\r\n|\r|\n)/),d=this.lineHeight==null?this.getMeasuredLineHeight():this.lineHeight,e=0,f=0,g=c.length;f<g;f++){var k=
b.measureText(c[f]).width;if(this.lineWidth==null||k<this.lineWidth)this._drawTextLine(b,c[f],e);else{for(var k=c[f].split(/(\s)/),h=k[0],l=1,j=k.length;l<j;l+=2)b.measureText(h+k[l]+k[l+1]).width>this.lineWidth?(this._drawTextLine(b,h,e),e+=d,h=k[l+1]):h+=k[l]+k[l+1];this._drawTextLine(b,h,e)}e+=d}return true};a.getMeasuredWidth=function(){return this._getWorkingContext().measureText(this.text).width};a.getMeasuredLineHeight=function(){return this._getWorkingContext().measureText("M").width*1.2};
a.clone=function(){var b=new c(this.text,this.font,this.color);this.cloneProps(b);return b};a.toString=function(){return"[Text (text="+(this.text.length>20?this.text.substr(0,17)+"...":this.text)+")]"};a.DisplayObject_cloneProps=a.cloneProps;a.cloneProps=function(b){this.DisplayObject_cloneProps(b);b.textAlign=this.textAlign;b.textBaseline=this.textBaseline;b.maxWidth=this.maxWidth;b.outline=this.outline;b.lineHeight=this.lineHeight;b.lineWidth=this.lineWidth};a._getWorkingContext=function(){var b=
c._workingContext;b.font=this.font;b.textAlign=this.textAlign?this.textAlign:"start";b.textBaseline=this.textBaseline?this.textBaseline:"alphabetic";return b};a._drawTextLine=function(b,a,c){this.outline?b.strokeText(a,0,c,this.maxWidth):b.fillText(a,0,c,this.maxWidth||65535)};j.Text=c})(window);(function(j){var c=function(){throw"SpriteSheetUtils cannot be instantiated";};c._workingCanvas=document.createElement("canvas");c._workingContext=c._workingCanvas.getContext("2d");c.addFlippedFrames=function(a,b,j,i){if(b||j||i){var d=0;b&&c._flip(a,++d,true,false);j&&c._flip(a,++d,false,true);i&&c._flip(a,++d,true,true)}};c.extractFrame=function(a,b){isNaN(b)&&(b=a.getAnimation(b).frames[0]);var j=a.getFrame(b);if(!j)return null;var i=j.rect,d=c._workingCanvas;d.width=i.width;d.height=i.height;
c._workingContext.drawImage(j.image,i.x,i.y,i.width,i.height,0,0,i.width,i.height);j=new Image;j.src=d.toDataURL("image/png");return j};c._flip=function(a,b,j,i){for(var d=a._images,e=c._workingCanvas,f=c._workingContext,g=d.length/b,k=0;k<g;k++){var h=d[k];h.__tmp=k;e.width=h.width;e.height=h.height;f.setTransform(j?-1:1,0,0,i?-1:1,j?h.width:0,i?h.height:0);f.drawImage(h,0,0);var l=new Image;l.src=e.toDataURL("image/png");l.width=h.width;l.height=h.height;d.push(l)}f=a._frames;e=f.length/b;for(k=
0;k<e;k++){var h=f[k],o=h.rect.clone(),l=d[h.image.__tmp+g*b],m={image:l,rect:o,regX:h.regX,regY:h.regY};if(j)o.x=l.width-o.x-o.width,m.regX=o.width-h.regX;if(i)o.y=l.height-o.y-o.height,m.regY=o.height-h.regY;f.push(m)}j="_"+(j?"h":"")+(i?"v":"");i=a._animations;a=a._data;d=i.length/b;for(k=0;k<d;k++){f=i[k];h=a[f];g={name:f+j,frequency:h.frequency,next:h.next,frames:[]};h.next&&(g.next+=j);f=h.frames;h=0;for(l=f.length;h<l;h++)g.frames.push(f[h]+e*b);a[g.name]=g;i.push(g.name)}};j.SpriteSheetUtils=
c})(window);(function(j){var c=function(b){this.initialize(b)},a=c.prototype=new DisplayObject;a.htmlElement=null;a._style=null;a.DisplayObject_initialize=a.initialize;a.initialize=function(b){typeof b=="string"&&(b=document.getElementById(b));this.DisplayObject_initialize();this.mouseEnabled=false;if(this.htmlElement=b)this._style=b.style,this._style.position="absolute",this._style.transformOrigin=this._style.webkitTransformOrigin=this._style.msTransformOrigin=this._style.MozTransformOrigin="0% 0%"};a.isVisible=
function(){return this.htmlElement!=null};a.draw=function(){if(this.htmlElement!=null){var b=this._matrix,a=this.htmlElement;a.style.opacity=""+b.alpha;a.style.visibility=this.visible?"visible":"hidden";a.style.transform=a.style.webkitTransform=a.style.oTransform=a.style.msTransform=["matrix("+b.a,b.b,b.c,b.d,b.tx,b.ty+")"].join(",");a.style.MozTransform=["matrix("+b.a,b.b,b.c,b.d,b.tx+"px",b.ty+"px)"].join(",");return true}};a.cache=function(){};a.uncache=function(){};a.updateCache=function(){};
a.hitTest=function(){};a.localToGlobal=function(){};a.globalToLocal=function(){};a.localToLocal=function(){};a.clone=function(){var a=new c;this.cloneProps(a);return a};a.toString=function(){return"[DOMElement (name="+this.name+")]"};a._tick=function(a){if(this.htmlElement!=null&&(this.htmlElement.style.visibility="hidden",this.onTick))this.onTick(a)};j.DOMElement=c})(window);(function(j){var c=function(){this.initialize()},a=c.prototype;a.initialize=function(){};a.getBounds=function(){return new Rectangle(0,0,0,0)};a.applyFilter=function(){};a.toString=function(){return"[Filter]"};a.clone=function(){return new c};j.Filter=c})(window);(function(j){var c=function(){throw"Touch cannot be instantiated";};c.isSupported=function(){return"ontouchstart"in j};c.enable=function(a){if(a!=null&&c.isSupported())a._primaryTouchId=-1,a._handleTouchMoveListener=null,a.canvas.addEventListener("touchstart",function(b){c._handleTouchStart(a,b)},false),document.addEventListener("touchend",function(b){c._handleTouchEnd(a,b)},false)};c._handleTouchStart=function(a,b){b.preventDefault();if(a._primaryTouchId==-1){a._handleTouchMoveListener=a._handleTouchMoveListener||
function(b){c._handleTouchMove(a,b)};document.addEventListener("touchmove",a._handleTouchMoveListener,false);var j=b.changedTouches[0];a._primaryTouchId=j.identifier;a._updateMousePosition(j.pageX,j.pageY);a._handleMouseDown(j)}};c._handleTouchMove=function(a,b){var j=c._findPrimaryTouch(a,b.changedTouches);j&&a._handleMouseMove(j)};c._handleTouchEnd=function(a,b){var j=c._findPrimaryTouch(a,b.changedTouches);if(j)a._primaryTouchId=-1,a._handleMouseUp(j),document.removeEventListener("touchmove",a._handleTouchMoveListener),
a._handleTouchMoveListener=null};c._findPrimaryTouch=function(a,b){for(var c=b.length,i=0;i<c;i++){var d=b[i];if(d.identifier==a._primaryTouchId)return d}return null};j.Touch=c})(window);
/**
* EaselJS
* Visit http://easeljs.com/ for documentation, updates and examples.
*
* Copyright (c) 2011 Grant Skinner
* 
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
* 
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
**/
(function(k){var b=function(g,a){this.initialize(g,a)},a=b.prototype;b.NONE=0;b.LOOP=1;b.REVERSE=2;b.IGNORE={};b._tweens=[];b._plugins={};b.get=function(g,a){return new b(g,a)};b.tick=function(g,a){for(var c=b._tweens,e=c.length-1;e>=0;e--){var d=c[e];if(!a||d.ignoreGlobalPause)d.tick(d._useTicks?1:g)}};Ticker&&Ticker.addListener(b,false);b.removeTweens=function(g){if(g.tweenjs_count){for(var a=b._tweens,c=a.length-1;c>=0;c--)a[c]._target==g&&a.splice(c,1);g.tweenjs_count=0}};b.installPlugin=function(g,
a){var c=g.priority;if(c==null)g.priority=c=0;for(var e=0,d=a.length,f=b._plugins;e<d;e++){var i=a[e];if(f[i]){for(var l=f[i],j=0,k=l.length;j<k;j++)if(c<l[j].priority)break;f[i].splice(j,0,g)}else f[i]=[g]}};b._register=function(g,a){var c=g._target;if(a){if(c)c.tweenjs_count=c.tweenjs_count?c.tweenjs_count+1:1;b._tweens.push(g)}else c&&c.tweenjs_count--,c=b._tweens.indexOf(g),c!=-1&&b._tweens.splice(c,1)};a.ignoreGlobalPause=false;a.loop=false;a.duration=0;a.pluginData=null;a._paused=false;a._curQueueProps=
null;a._initQueueProps=null;a._steps=null;a._actions=null;a._prevPosition=0;a._stepPosition=0;a._prevPos=-1;a._target=null;a._useTicks=false;a.initialize=function(g,a,c){this._target=g;if(a)this._useTicks=a.useTicks,this.ignoreGlobalPause=a.ignoreGlobalPause,this.loop=a.loop,a.override&&b.removeTweens(g);this.pluginData=c||{};this._curQueueProps={};this._initQueueProps={};this._steps=[];this._actions=[];this._catalog=[];(!a||!a.paused)&&b._register(this,true);a&&a.position!=null&&this.setPosition(a.position,
b.NONE)};a.wait=function(g){if(g==null||g<=0)return this;var a=this._cloneProps(this._curQueueProps);return this._addStep({d:g,p0:a,e:this._linearEase,p1:a})};a.to=function(a,b,c){if(isNaN(b)||b<0)b=0;return this._addStep({d:b||0,p0:this._cloneProps(this._curQueueProps),e:c,p1:this._cloneProps(this._appendQueueProps(a))})};a.call=function(a,b,c){return this._addAction({f:a,p:b?b:[this],o:c?c:this._target})};a.set=function(a,b){return this._addAction({f:this._set,o:this,p:[a,b?b:this._target]})};a.play=
function(a){return this.call(a.setPaused,[false],a)};a.pause=function(a){a||(a=this);return this.call(a.setPaused,[true],a)};a.setPosition=function(a,b){a<0&&(a=0);b==null&&(b=1);var c=a,e=false;if(c>=this.duration)this.loop?c%=this.duration:(c=this.duration,e=true);if(c==this._prevPos)return e;if(this._target)if(e)this._updateTargetProps(null,1);else if(this._steps.length>0){for(var d=0,f=this._steps.length;d<f;d++)if(this._steps[d].t>c)break;d=this._steps[d-1];this._updateTargetProps(d,(this._stepPosition=
c-d.t)/d.d,c)}d=this._prevPos;this._prevPos=c;this._prevPosition=a;b!=0&&this._actions.length>0&&(this._useTicks?this._runActions(c,c):b==1&&c<d?(d!=this.duration&&this._runActions(d,this.duration),this._runActions(0,c,true)):this._runActions(d,c));e&&this.setPaused(true);return e};a.tick=function(a){this._paused||this.setPosition(this._prevPosition+a)};a.setPaused=function(a){if(this._paused!=!!a)this._paused=!!a,b._register(this,!a)};a.w=a.wait;a.t=a.to;a.c=a.call;a.s=a.set;a.toString=function(){return"[Tween]"};
a.clone=function(){throw"Tween can not be cloned.";};a._updateTargetProps=function(a,h,c){var e,d,f,i;!a&&h==1?e=d=this._curQueueProps:(a.e&&(h=a.e(h,0,1,1)),e=a.p0,d=a.p1);for(n in this._initQueueProps){if((f=e[n])==null)e[n]=f=this._initQueueProps[n];if((i=d[n])==null)d[n]=i=f;f=f==i||h==0||h==1||typeof f!="number"?h==1?i:f:f+(i-f)*h;var l=false;if(i=b._plugins[n])for(var j=0,k=i.length;j<k;j++){var m=i[j].tween(this,n,f,e,d,h,c,!a);m==b.IGNORE?l=true:f=m}l||(this._target[n]=f)}};a._runActions=
function(a,b,c){var e=a,d=b,f=-1,i=this._actions.length,k=1;a>b&&(e=b,d=a,f=i,i=k=-1);for(;(f+=k)!=i;){var b=this._actions[f],j=b.t;(j==d||j>e&&j<d||c&&j==a)&&b.f.apply(b.o,b.p)}};a._appendQueueProps=function(a){var h,c,e,d;for(d in a){if(this._initQueueProps[d]==null){c=this._target[d];if(h=b._plugins[d])for(var f=0,i=h.length;f<i;f++)e=h[f].init(this,d,c),e!=b.IGNORE&&(c=e);this._initQueueProps[d]=c}this._curQueueProps[d]=a[d]}return this._curQueueProps};a._cloneProps=function(a){var b={},c;for(c in a)b[c]=
a[c];return b};a._addStep=function(a){if(a.d>0)this._steps.push(a),a.t=this.duration,this.duration+=a.d;return this};a._addAction=function(a){a.t=this.duration;this._actions.push(a);return this};a._set=function(a,b){for(var c in a)b[c]=a[c]};k.Tween=b})(window);(function(k){var b=function(a,b,c){this.initialize(a,b,c)},a=b.prototype;a.ignoreGlobalPause=false;a.duration=0;a.loop=false;a._paused=true;a._tweens=null;a._labels=null;a._prevPosition=0;a._prevPos=-1;a._useTicks=false;a.initialize=function(a,b,c){this._tweens=[];if(c)this._useTicks=c.useTicks,this.loop=c.loop,this.ignoreGlobalPause=c.ignoreGlobalPause;a&&this.addTween.apply(this,a);this.setLabels(b);(!c||!c.paused)&&Tween._register(this,true);c&&c.position!=null&&this.setPosition(c.position,Tween.NONE)};
a.addTween=function(a){var b=arguments.length;if(b>1){for(var c=0;c<b;c++)this.addTween(arguments[c]);return arguments[0]}else if(b==0)return null;this.removeTween(a);this._tweens.push(a);a.setPaused(true);a._paused=false;a._useTicks=this._useTicks;if(a.duration>this.duration)this.duration=a.duration;this._prevPos>=0&&a.setPosition(this._prevPos,Tween.NONE);return a};a.removeTween=function(a){var b=arguments.length;if(b>1){for(var c=true,e=0;e<b;e++)c=c&&this.removeTween(arguments[e]);return c}else if(b==
0)return false;b=this._tweens.indexOf(a);return b!=-1?(this._tweens.splice(b,1),a.duration>=this.duration&&this.updateDuration(),true):false};a.addLabel=function(a,b){this._labels[a]=b};a.setLabels=function(a){this._labels=a?a:{}};a.gotoAndPlay=function(a){this.setPaused(false);this._goto(a)};a.gotoAndStop=function(a){this.setPaused(true);this._goto(a)};a.setPosition=function(a,b){a<0&&(a=0);var c=this.loop?a%this.duration:a,e=!this.loop&&a>=this.duration;if(c==this._prevPos)return e;this._prevPosition=
a;this._prevPos=c;for(var d=0,f=this._tweens.length;d<f;d++)if(this._tweens[d].setPosition(c,b),c!=this._prevPos)return false;e&&this.setPaused(true);return e};a.setPaused=function(a){if(this._paused!=!!a)this._paused=!!a,Tween._register(this,!a)};a.updateDuration=function(){for(var a=this.duration=0,b=this._tweens.length;a<b;a++)if(tween=this._tweens[a],tween.duration>this.duration)this.duration=tween.duration};a.tick=function(a){this.setPosition(this._prevPosition+a)};a.resolve=function(a){var b=
parseFloat(a);isNaN(b)&&(b=this._labels[a]);return b};a.toString=function(){return"[Timeline]"};a.clone=function(){throw"Timeline can not be cloned.";};a._goto=function(a){a=this.resolve(a);a!=null&&this.setPosition(a)};k.Timeline=b})(window);(function(k){var b=function(){throw"Ease cannot be instantiated.";};b.linear=function(a){return a};b.none=b.linear;b.get=function(a){a<-1&&(a=-1);a>1&&(a=1);return function(b){return a==0?b:a<0?b*(b*-a+1+a):b*((2-b)*a+(1-a))}};b.getPowIn=function(a){return function(b){return Math.pow(b,a)}};b.getPowOut=function(a){return function(b){return 1-Math.pow(1-b,a)}};b.getPowInOut=function(a){return function(b){return(b*=2)<1?0.5*Math.pow(b,a):1-0.5*Math.abs(Math.pow(2-b,a))}};b.quadIn=b.getPowIn(2);b.quadOut=
b.getPowOut(2);b.quadInOut=b.getPowInOut(2);b.cubicIn=b.getPowIn(3);b.cubicOut=b.getPowOut(3);b.cubicInOut=b.getPowInOut(3);b.quartIn=b.getPowIn(4);b.quartOut=b.getPowOut(4);b.quartInOut=b.getPowInOut(4);b.quintIn=b.getPowIn(5);b.quintOut=b.getPowOut(5);b.quintInOut=b.getPowInOut(5);b.sineIn=function(a){return 1-Math.cos(a*Math.PI/2)};b.sineOut=function(a){return Math.sin(a*Math.PI/2)};b.sineInOut=function(a){return-0.5*(Math.cos(Math.PI*a)-1)};b.getBackIn=function(a){return function(b){return b*
b*((a+1)*b-a)}};b.backIn=b.getBackIn(1.7);b.getBackOut=function(a){return function(b){return--b*b*((a+1)*b+a)+1}};b.backOut=b.getBackOut(1.7);b.getBackInOut=function(a){a*=1.525;return function(b){return(b*=2)<1?0.5*b*b*((a+1)*b-a):0.5*((b-=2)*b*((a+1)*b+a)+2)}};b.backInOut=b.getBackInOut(1.7);b.circIn=function(a){return-(Math.sqrt(1-a*a)-1)};b.circOut=function(a){return Math.sqrt(1- --a*a)};b.circInOut=function(a){return(a*=2)<1?-0.5*(Math.sqrt(1-a*a)-1):0.5*(Math.sqrt(1-(a-=2)*a)+1)};b.bounceIn=
function(a){return 1-b.bounceOut(1-a)};b.bounceOut=function(a){return a<1/2.75?7.5625*a*a:a<2/2.75?7.5625*(a-=1.5/2.75)*a+0.75:a<2.5/2.75?7.5625*(a-=2.25/2.75)*a+0.9375:7.5625*(a-=2.625/2.75)*a+0.984375};b.bounceInOut=function(a){return a<0.5?b.bounceIn(a*2)*0.5:b.bounceOut(a*2-1)*0.5+0.5};b.getElasticIn=function(a,b){var h=Math.PI*2;return function(c){if(c==0||c==1)return c;var e=b/h*Math.asin(1/a);return-(a*Math.pow(2,10*(c-=1))*Math.sin((c-e)*h/b))}};b.elasticIn=b.getElasticIn(1,0.3);b.getElasticOut=
function(a,b){var h=Math.PI*2;return function(c){if(c==0||c==1)return c;var e=b/h*Math.asin(1/a);return a*Math.pow(2,-10*c)*Math.sin((c-e)*h/b)+1}};b.elasticOut=b.getElasticOut(1,0.3);b.getElasticInOut=function(a,b){var h=Math.PI*2;return function(c){var e=b/h*Math.asin(1/a);return(c*=2)<1?-0.5*a*Math.pow(2,10*(c-=1))*Math.sin((c-e)*h/b):a*Math.pow(2,-10*(c-=1))*Math.sin((c-e)*h/b)*0.5+1}};b.elasticInOut=b.getElasticInOut(1,0.3*1.5);k.Ease=b})(window);
/**
* EaselJS
* Visit http://easeljs.com/ for documentation, updates and examples.
*
* Copyright (c) 2011 Grant Skinner
* 
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
* 
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
**/
(function(d){var c=function(b,a,c,e){this.initialize(b,a,c,e)},a=c.prototype=new Container;c.INDEPENDENT="independent";c.SINGLE_FRAME="single";c.SYNCHED="synched";a.startPosition=0;a.loop=true;a.timeline=null;a.paused=false;a._synchOffset=0;a._prevPos=-1;a._prevPosition=0;a.Container_initialize=a.initialize;a.initialize=function(b,a,g,e){this.mode=b||c.INDEPENDENT;this.startPosition=a||0;this.loop=g;props={paused:true,position:a,useTicks:true};this.Container_initialize();this.timeline=new Timeline(null,
e,props);this._managed={}};a.isVisible=function(){return this.visible&&this.alpha>0&&this.scaleX!=0&&this.scaleY!=0};a.Container_draw=a.draw;a.draw=function(b,a,c){if(this.DisplayObject_draw(b,a))return true;this._updateTimeline();this.Container_draw(b,a,c)};a.play=function(){this.paused=false};a.stop=function(){this.paused=true};a.gotoAndPlay=function(b){this.paused=false;this._goto(b)};a.gotoAndStop=function(b){this.paused=true;this._goto(b)};a.clone=function(){throw"MovieClip cannot be cloned.";
};a.toString=function(){return"[MovieClip (name="+this.name+")]"};a.Container__tick=a._tick;a._tick=function(){if(!this.paused&&this.mode==c.INDEPENDENT)this._prevPosition=this._prevPos<0?0:this._prevPosition+1;this.Container__tick()};a._goto=function(b){b=this.timeline.resolve(b);if(b!=null)this._prevPosition=b,this._updateTimeline()};a._reset=function(){this._prevPos=-1};a._updateTimeline=function(){var b=this.timeline,a=b._tweens,g=this.children,e=this.mode!=c.INDEPENDENT;b.loop=this.loop==null?
true:this.loop;e?b.setPosition(this.startPosition+(this.mode==c.SINGLE_FRAME?0:this._synchOffset),Tween.NONE):b.setPosition(this._prevPosition);this._prevPosition=b._prevPosition;if(this._prevPos!=b._prevPos){this._prevPos=b._prevPos;for(var f in this._managed)this._managed[f]=1;for(b=a.length-1;b>=0;b--)if(f=a[b],e=f._target,e!=this)f=f._stepPosition,e instanceof DisplayObject?this._addManagedChild(e,f):this._setState(e.state,f);for(b=g.length-1;b>=0;b--)a=g[b].id,this._managed[a]==1&&(this.removeChildAt(b),
delete this._managed[a])}};a._setState=function(b,a){if(b)for(var c=0,e=b.length;c<e;c++){var f=b[c],d=f.t,f=f.p,h;for(h in f)d[h]=f[h];this._addManagedChild(d,a)}};a._addManagedChild=function(a,d){if(!a._off){this.addChild(a);if(a instanceof c)a._synchOffset=d,a.mode==c.INDEPENDENT&&(!this._managed[a.id]||this._prevPos==0)&&a._reset();this._managed[a.id]=2}};d.MovieClip=c})(window);
(function(){var d=function(){throw"MovieClipPlugin cannot be instantiated.";};d.priority=100;d.install=function(){Tween.installPlugin(d,["startPosition"])};d.init=function(c,a,b){if(a=="startPosition"||!(c._target instanceof MovieClip))return b};d.tween=function(c,a,b,d,g,e){return!(c._target instanceof MovieClip)?b:e==1?g[a]:d[a]};d.install()})();
/**
 * PreloadJS
 * Visit http://createjs.com/ for documentation, updates and examples.
 *
 * Copyright (c) 2011 gskinner.com, inc.
 *
 * Distributed under the terms of the MIT license.
 * http://www.opensource.org/licenses/mit-license.html
 *
 * This notice shall be included in all copies or substantial portions of the Software.
 *
 * ver. 1.3.0-1 created from release_v0.1.0
 **/

(function(c){var e=function(){this.init()};e.prototype={};var a=e.prototype;a.loaded=!1;a.progress=0;a._item=null;a.onProgress=null;a.onLoadStart=null;a.onFileLoad=null;a.onFileProgress=null;a.onComplete=null;a.onError=null;a.getItem=function(){return this._item};a.init=function(){};a.load=function(){};a.cancel=function(){};a._sendLoadStart=function(){if(this.onLoadStart)this.onLoadStart({target:this})};a._sendProgress=function(a){var b;if(a instanceof Number)this.progress=a,b={loaded:this.progress,
total:1};else if(b=a,this.progress=a.loaded/a.total,isNaN(this.progress)||Infinity==this.progress)this.progress=0;b.target=this;if(this.onProgress)this.onProgress(b)};a._sendFileProgress=function(a){this.onFileProgress&&(a.target=this,this.onFileProgress(a))};a._sendComplete=function(){if(this.onComplete)this.onComplete({target:this})};a._sendFileComplete=function(a){this.onFileLoad&&(a.target=this,this.onFileLoad(a))};a._sendError=function(a){this.onError&&(null==a&&(a={}),a.target=this,this.onError(a))};
a.toString=function(){return"[PreloadJS AbstractLoader]"};c.AbstractLoader=e})(createjs||(createjs={}));var createjs;
(function(c){var e=function(b){this.initialize(b)},a=e.prototype=new c.AbstractLoader;e.IMAGE="image";e.SVG="svg";e.SOUND="sound";e.JSON="json";e.JAVASCRIPT="javascript";e.CSS="css";e.XML="xml";e.TEXT="text";e.TIMEOUT_TIME=2E3;a.useXHR=!0;a.stopOnError=!1;a.maintainScriptOrder=!0;a.next=null;a.typeHandlers=null;a.extensionHandlers=null;a._loadStartWasDispatched=!1;a._maxConnections=1;a._currentLoads=null;a._loadQueue=null;a._loadedItemsById=null;a._loadedItemsBySrc=null;a._targetProgress=0;a._numItems=
0;a._numItemsLoaded=null;a._scriptOrder=null;a._loadedScripts=null;a.TAG_LOAD_OGGS=!0;a.initialize=function(b){this._targetProgress=this._numItemsLoaded=this._numItems=0;this._paused=!1;this._currentLoads=[];this._loadQueue=[];this._scriptOrder=[];this._loadedScripts=[];this._loadedItemsById={};this._loadedItemsBySrc={};this.typeHandlers={};this.extensionHandlers={};this._loadStartWasDispatched=!1;this.useXHR=!1!=b&&null!=window.XMLHttpRequest;this.determineCapabilities()};a.determineCapabilities=
function(){var b=c.BrowserDetect;null!=b&&(c.PreloadJS.TAG_LOAD_OGGS=b.isFirefox||b.isOpera)};e.isBinary=function(b){switch(b){case c.PreloadJS.IMAGE:case c.PreloadJS.SOUND:return!0;default:return!1}};a.installPlugin=function(b){if(!(null==b||null==b.getPreloadHandlers)){b=b.getPreloadHandlers();if(null!=b.types)for(var a=0,d=b.types.length;a<d;a++)this.typeHandlers[b.types[a]]=b.callback;if(null!=b.extensions){a=0;for(d=b.extensions.length;a<d;a++)this.extensionHandlers[b.extensions[a]]=b.callback}}};
a.setMaxConnections=function(b){this._maxConnections=b;this._paused||this._loadNext()};a.loadFile=function(b,a){null==b?this._sendError({text:"File is null."}):(this._addItem(b),!1!==a&&this.setPaused(!1))};a.loadManifest=function(b,a){var d;if(b instanceof Array){if(0==b.length){this._sendError({text:"Manifest is empty."});return}d=b}else{if(null==b){this._sendError({text:"Manifest is null."});return}d=[b]}for(var c=0,e=d.length;c<e;c++)this._addItem(d[c],!1);!1!==a&&this._loadNext()};a.load=function(){this.setPaused(!1)};
a.getResult=function(b){return this._loadedItemsById[b]||this._loadedItemsBySrc[b]};a.setPaused=function(b){(this._paused=b)||this._loadNext()};a.close=function(){for(;this._currentLoads.length;)this._currentLoads.pop().cancel();this._currentLoads=[];this._scriptOrder=[];this._loadedScripts=[]};a._addItem=function(b){b=this._createLoadItem(b);null!=b&&(this._loadQueue.push(b),this._numItems++,this._updateProgress(),b.getItem().type==c.PreloadJS.JAVASCRIPT&&(this._scriptOrder.push(b.getItem()),this._loadedScripts.push(null)))};
a._loadNext=function(){if(!this._paused){this._loadStartWasDispatched||(this._sendLoadStart(),this._loadStartWasDispatched=!0);this._numItems==this._numItemsLoaded&&(this.loaded=!0,this._sendComplete(),this.next&&this.next.load&&this.next.load.apply(this.next));for(;this._loadQueue.length&&this._currentLoads.length<this._maxConnections;)this._loadItem(this._loadQueue.shift())}};a._loadItem=function(b){b.onProgress=c.PreloadJS.proxy(this._handleProgress,this);b.onComplete=c.PreloadJS.proxy(this._handleFileComplete,
this);b.onError=c.PreloadJS.proxy(this._handleFileError,this);this._currentLoads.push(b);b.load()};a._handleFileError=function(b){var b=b.target,a=this._createResultData(b.getItem());this._numItemsLoaded++;this._updateProgress();this._sendError(a);this.stopOnError||(this._removeLoadItem(b),this._loadNext())};a._createResultData=function(b){var a={id:b.id,result:null,data:b.data,type:b.type,src:b.src};this._loadedItemsById[b.id]=a;return this._loadedItemsBySrc[b.src]=a};a._handleFileComplete=function(b){var b=
b.target,a=b.getItem(),d=this._createResultData(a);this._removeLoadItem(b);d.result=b instanceof c.XHRLoader?this._createResult(a,b.getResult()):a.tag;switch(a.type){case c.PreloadJS.IMAGE:if(b instanceof c.XHRLoader){var e=this;d.result.onload=function(){e._handleFileTagComplete(a,d)};return}break;case c.PreloadJS.JAVASCRIPT:if(this.maintainScriptOrder){this._loadedScripts[this._scriptOrder.indexOf(a)]=a;this._checkScriptLoadOrder(b);return}}this._handleFileTagComplete(a,d)};a._checkScriptLoadOrder=
function(){for(var b=this._loadedScripts.length,a=0;a<b;a++){var d=this._loadedScripts[a];if(null===d)break;if(!0!==d){var c=this.getResult(d.src),d=this.getResult(d.id);d.result=c.result;this._handleFileTagComplete(c,d);this._loadedScripts[a]=!0;a--;b--}}};a._handleFileTagComplete=function(b,a){this._numItemsLoaded++;b.completeHandler&&b.completeHandler(a);this._updateProgress();this._sendFileComplete(a);this._loadNext()};a._removeLoadItem=function(b){for(var a=this._currentLoads.length,d=0;d<a;d++)if(this._currentLoads[d]==
b){this._currentLoads.splice(d,1);break}};a._createResult=function(b,a){var d=null,e;switch(b.type){case c.PreloadJS.IMAGE:d=this._createImage();break;case c.PreloadJS.SOUND:d=b.tag||this._createAudio();break;case c.PreloadJS.CSS:d=this._createLink();break;case c.PreloadJS.JAVASCRIPT:d=this._createScript();break;case c.PreloadJS.SVG:var d=this._createSVG(),g=this._createXML(a,"image/svg+xml");d.appendChild(g);break;case c.PreloadJS.XML:e=this._createXML(a,"text/xml");break;case c.PreloadJS.JSON:case c.PreloadJS.TEXT:e=
a}return d?(b.type==c.PreloadJS.CSS?d.href=b.src:b.type!=c.PreloadJS.SVG&&(d.src=b.src),d):e};a._createXML=function(b,a){var d;window.DOMParser?(d=new DOMParser,d=d.parseFromString(b,a)):(d=new ActiveXObject("Microsoft.XMLDOM"),d.async=!1,d.loadXML(b));return d};a._handleProgress=function(b){var b=b.target,a=this._createResultData(b.getItem());a.progress=b.progress;this._sendFileProgress(a);this._updateProgress()};a._updateProgress=function(){var b=this._numItemsLoaded/this._numItems,a=this._numItems-
this._numItemsLoaded;if(0<a){for(var d=0,c=0,e=this._currentLoads.length;c<e;c++)d+=this._currentLoads[c].progress;b+=d/a*(a/this._numItems)}this._sendProgress({loaded:b,total:1})};a._isInstanceOfHTMLAudioElement=function(b){try{return b instanceof HTMLAudioElement}catch(a){return!1}};a._createLoadItem=function(b){var a={};switch(typeof b){case "string":a.src=b;break;case "object":this._isInstanceOfHTMLAudioElement(b)?(a.tag=b,a.src=a.tag.src,a.type=c.PreloadJS.SOUND):a=b}a.ext=this._getNameAfter(a.src,
".");a.type||(a.type=this.getType(a.ext));if(null==a.id||""==a.id)a.id=a.src;if(b=this.typeHandlers[a.type]||this.extensionHandlers[a.ext]){b=b(a.src,a.type,a.id,a.data);if(!1===b)return null;if(!0!==b&&(null!=b.src&&(a.src=b.src),null!=b.id&&(a.id=b.id),null!=b.tag&&b.tag.load instanceof Function))a.tag=b.tag;a.ext=this._getNameAfter(a.src,".")}b=this.useXHR;switch(a.type){case c.PreloadJS.JSON:case c.PreloadJS.XML:case c.PreloadJS.TEXT:b=!0;break;case c.PreloadJS.SOUND:"ogg"==a.ext&&c.PreloadJS.TAG_LOAD_OGGS&&
(b=!1)}return!0==this.useXHR&&(a.type==c.PreloadJS.IMAGE||a.type==c.PreloadJS.SVG)?(a=this._createTagItem(a),a.useXHR=!0,a):b?new c.XHRLoader(a):a.tag?new c.TagLoader(a):this._createTagItem(a)};a._createTagItem=function(a){var d,e="src",f=!1;switch(a.type){case c.PreloadJS.IMAGE:d=this._createImage();break;case c.PreloadJS.SOUND:d=this._createAudio();break;case c.PreloadJS.CSS:e="href";f=!0;d=this._createLink();break;case c.PreloadJS.JAVASCRIPT:f=!0;d=this._createScript();break;case c.PreloadJS.SVG:e=
"data",d=this._createSVG()}a.tag=d;return new c.TagLoader(a,e,f)};a.getType=function(a){switch(a){case "jpeg":case "jpg":case "gif":case "png":return c.PreloadJS.IMAGE;case "ogg":case "mp3":case "wav":return c.PreloadJS.SOUND;case "json":return c.PreloadJS.JSON;case "xml":return c.PreloadJS.XML;case "css":return c.PreloadJS.CSS;case "js":return c.PreloadJS.JAVASCRIPT;case "svg":return c.PreloadJS.SVG;default:return c.PreloadJS.TEXT}};a._getNameAfter=function(a,d){var c=a.lastIndexOf(d),c=a.substr(c+
1),e=c.lastIndexOf(/[\b|\?|\#|\s]/);return-1==e?c:c.substr(0,e)};a._createImage=function(){return document.createElement("img")};a._createSVG=function(){var a=document.createElement("object");a.type="image/svg+xml";return a};a._createAudio=function(){var a=document.createElement("audio");a.autoplay=!1;a.type="audio/ogg";return a};a._createScript=function(){var a=document.createElement("script");a.type="text/javascript";return a};a._createLink=function(){var a=document.createElement("link");a.type=
"text/css";a.rel="stylesheet";return a};a.toString=function(){return"[PreloadJS]"};e.proxy=function(a,d){return function(c){return a.apply(d,arguments)}};c.PreloadJS=e;var d=function(){};d.init=function(){var a=navigator.userAgent;d.isFirefox=-1<a.indexOf("Firefox");d.isOpera=null!=window.opera;d.isIOS=-1<a.indexOf("iPod")||-1<a.indexOf("iPhone")||-1<a.indexOf("iPad")};d.init();c.BrowserDetect=d})(createjs||(createjs={}));
(function(c){var e=function(a,b,c){this.init(a,b,c)},a=e.prototype=new c.AbstractLoader;a._srcAttr=null;a._loadTimeOutTimeout=null;a.tagCompleteProxy=null;a.init=function(a,b,e){this._item=a;this._srcAttr=b||"src";this.useXHR=!0==e;this.isAudio=this._isAudioTag(a.tag);this.tagCompleteProxy=c.PreloadJS.proxy(this._handleTagLoad,this)};a.cancel=function(){this._clean();var a=this.getItem();null!=a&&(a.src=null)};a.load=function(){this.useXHR?this.loadXHR():this.loadTag()};a.loadXHR=function(){var a=
this.getItem(),a=new c.XHRLoader(a);a.onProgress=c.PreloadJS.proxy(this._handleProgress,this);a.onFileLoad=c.PreloadJS.proxy(this._handleXHRComplete,this);a.onComplete=c.PreloadJS.proxy(this._handleXHRComplete,this);a.onError=c.PreloadJS.proxy(this._handleLoadError,this);a.load()};a._handleXHRComplete=function(a){this._clean();a.target.onFileLoad=null;a.target.onComplete=null;var b=a.target.getItem();a.target.getResult();b.type==c.PreloadJS.IMAGE?(b.tag.onload=c.PreloadJS.proxy(this._sendComplete,
this),b.tag.src=b.src):(b.tag[this._srcAttr]=b.src,this._sendComplete())};a._handleLoadError=function(a){a.error&&101==a.error.code?this.loadTag():(this._clean(),this._sendError(a))};a._isAudioTag=function(a){try{return a instanceof HTMLAudioElement}catch(b){return!1}};a.loadTag=function(){var a=this.getItem(),b=a.tag;clearTimeout(this._loadTimeOutTimeout);this._loadTimeOutTimeout=setTimeout(c.PreloadJS.proxy(this._handleLoadTimeOut,this),c.PreloadJS.TIMEOUT_TIME);this.isAudio&&(b.src=null,b.preload=
"auto",b.setAttribute("data-temp","true"));b.onerror=c.PreloadJS.proxy(this._handleLoadError,this);b.onprogress=c.PreloadJS.proxy(this._handleProgress,this);this.isAudio?(b.onstalled=c.PreloadJS.proxy(this._handleStalled,this),b.addEventListener("canplaythrough",this.tagCompleteProxy,!1)):b.onload=c.PreloadJS.proxy(this._handleTagLoad,this);b[this._srcAttr]=a.src;a.type==c.PreloadJS.SVG&&document.getElementsByTagName("body")[0].appendChild(b);a=a.type==c.PreloadJS.SOUND&&"ogg"==a.ext&&c.BrowserDetect.isFirefox;
null!=b.load&&!a&&b.load();b=this._getNameAfter(b.src,".");(this.isAudio||"ogg"==b||"mp3"==b||"mp4"==b||"ogv"==b)&&this._handleLoadTimeOut()};a._handleLoadTimeOut=function(){this._clean();this._sendError()};a._handleStalled=function(){};a._handleLoadError=function(){this._clean();this._sendError()};a._handleTagLoad=function(){var a=this.getItem().tag;clearTimeout(this._loadTimeOutTimeout);this.loaded||this.isAudio&&4!==a.readyState||(this.getItem().type==c.PreloadJS.SVG&&document.getElementsByTagName("body")[0].removeChild(a),
this.loaded=!0,this._clean(),this._sendComplete())};a._clean=function(){clearTimeout(this._loadTimeOutTimeout);var a=this.getItem().tag;a.onload=null;null!=a.removeEventListener&&a.removeEventListener("canplaythrough",this.tagCompleteProxy,!1);a.onstalled=null;a.onprogress=null;a.onerror=null};a._handleProgress=function(a){clearTimeout(this._loadTimeOutTimeout);if(this.isAudio){a=this.getItem();if(null==a.buffered)return;a={loaded:0<a.buffered.length?a.buffered.end(0):0,total:a.duration}}this._sendProgress(a)};
a.toString=function(){return"[PreloadJS TagLoader]"};a._getNameAfter=function(a,b){var c=a.lastIndexOf(b),c=a.substr(c+1),e=c.lastIndexOf(/[\b|\?|\#|\s]/);return-1==e?c:c.substr(0,e)};c.TagLoader=e})(createjs||(createjs={}));
(function(c){var e=function(a){this.init(a)},a=e.prototype=new c.AbstractLoader;a._wasLoaded=!1;a._request=null;a._loadTimeOutTimeout=null;a._xhrLevel=null;a.init=function(a){this._item=a;this._createXHR(a)};a.getResult=function(){try{return this._request.responseText}catch(a){}return this._request.response};a.cancel=function(){this._clean();this._request.abort()};a.load=function(){if(null==this._request)this.handleError();else{1==this._xhrLevel&&(this._loadTimeOutTimeout=setTimeout(c.PreloadJS.proxy(this.handleTimeout,
this),c.PreloadJS.TIMEOUT_TIME));this._request.onloadstart=c.PreloadJS.proxy(this.handleLoadStart,this);this._request.onprogress=c.PreloadJS.proxy(this.handleProgress,this);this._request.onabort=c.PreloadJS.proxy(this.handleAbort,this);this._request.onerror=c.PreloadJS.proxy(this.handleError,this);this._request.ontimeout=c.PreloadJS.proxy(this.handleTimeout,this);this._request.onload=c.PreloadJS.proxy(this.handleLoad,this);this._request.onreadystatechange=c.PreloadJS.proxy(this.handleReadyStateChange,
this);try{this._request.send()}catch(a){this._sendError({source:a})}}};a.handleProgress=function(a){0<a.loaded&&0==a.total||this._sendProgress({loaded:a.loaded,total:a.total})};a.handleLoadStart=function(){clearTimeout(this._loadTimeOutTimeout);this._sendLoadStart()};a.handleAbort=function(){this._clean();this._sendError()};a.handleError=function(){this._clean();this._sendError()};a.handleReadyStateChange=function(){4==this._request.readyState&&this.handleLoad()};a._checkError=function(){switch(parseInt(this._request.status)){case 404:case 0:return!1}return this._hasResponse()||
this._hasTextResponse()||this._hasXMLResponse()};a._hasResponse=function(){return null!=this._request.response};a._hasTextResponse=function(){try{return null!=this._request.responseText}catch(a){return!1}};a._hasXMLResponse=function(){try{return null!=this._request.responseXML}catch(a){return!1}};a.handleLoad=function(){this.loaded||(this.loaded=!0,this._checkError()?(this._clean(),this._sendComplete()):this.handleError())};a.handleTimeout=function(){this._clean();this._sendError()};a._createXHR=
function(a){this._xhrLevel=1;window.ArrayBuffer&&(this._xhrLevel=2);if(window.XMLHttpRequest)this._request=new XMLHttpRequest;else try{this._request=new ActiveXObject("MSXML2.XMLHTTP.3.0")}catch(b){return null}a.type==c.PreloadJS.TEXT&&this._request.overrideMimeType&&this._request.overrideMimeType("text/plain; charset=x-user-defined");this._request.open("GET",a.src,!0);c.PreloadJS.isBinary(a.type)&&(this._request.responseType="arraybuffer");return!0};a._clean=function(){clearTimeout(this._loadTimeOutTimeout);
var a=this._request;a.onloadstart=null;a.onprogress=null;a.onabort=null;a.onerror=null;a.onload=null;a.ontimeout=null;a.onloadend=null;a.onreadystatechange=null;clearInterval(this._checkLoadInterval)};a.toString=function(){return"[PreloadJS XHRLoader]"};c.XHRLoader=e})(createjs||(createjs={}));
/**
 * SoundJS
 * Visit http://createjs.com/ for documentation, updates and examples.
 *
 * Copyright (c) 2011 gskinner.com, inc.
 *
 * Distributed under the terms of the MIT license.
 * http://www.opensource.org/licenses/mit-license.html
 *
 * This notice shall be included in all copies or substantial portions of the Software.
 *
 * ver. 1.3.0-3 created from release_v0.2.0
 **/

(function(h){function a(){throw"SoundJS cannot be instantiated";}function f(b,a){this.init(b,a)}function d(){}var c=-1!=navigator.userAgent.indexOf("Firefox")?"ogg":"mp3";a.DELIMITER="|";a.AUDIO_TIMEOUT=8E3;a.INTERRUPT_ANY="any";a.INTERRUPT_EARLY="early";a.INTERRUPT_LATE="late";a.INTERRUPT_NONE="none";a.PLAY_INITED="playInited";a.PLAY_SUCCEEDED="playSucceeded";a.PLAY_INTERRUPTED="playInterrupted";a.PLAY_FINISHED="playFinished";a.PLAY_FAILED="playFailed";a.activePlugin=null;a.muted=!1;a.pluginsRegistered=
!1;a.masterVolume=1;a.muted=!1;a.instances=[];a.instanceHash={};a.idHash=null;a.defaultSoundInstance=null;a.getPreloadHandlers=function(){return{callback:a.proxy(a.initLoad,a),types:["sound"],extensions:["mp3","ogg","wav"]}};a.registerPlugins=function(b){a.pluginsRegistered=!0;for(var c=0,e=b.length;c<e;c++){var g=b[c];if(null!=g&&g.isSupported())return a.activePlugin=new g,!0}return!1};a.registerPlugin=function(b){a.pluginsRegistered=!0;return b.isSupported()?(a.activePlugin=new b,!0):!1};a.isReady=
function(){return null!=a.activePlugin};a.getCapabilities=function(){return a.activePlugin?a.activePlugin.capabilities:null};a.getCapability=function(b){return null==a.activePlugin?null:a.activePlugin.capabilities[b]};a.initLoad=function(b,c,e,g){if(!a.checkPlugin(!0))return!1;b=a.parsePath(b,c,e,g);if(null==b)return!1;null!=e&&(null==a.idHash&&(a.idHash={}),a.idHash[e]=b.src);f.create(b.src,g);e=a.activePlugin.register(b.src,g);if(null!=e&&(null!=e.tag?b.tag=e.tag:e.src&&(b.src=e.src),null!=e.completeHandler))b.handler=
e.completeHandler;return b};a.parsePath=function(b,i,e,g){b=b.split(a.DELIMITER);i={type:i||"sound",id:e,data:g,handler:a.handleSoundReady};a.getCapabilities();for(e=b.length;0<e;)return b=b[0],e=b.lastIndexOf("."),b.substr(e+1).toLowerCase(),e=b.substr(0,e).split("/").pop(),i.name=e,i.src=b,i.extension=c,i;return null};a.play=function(b,i,e,g,k,d,f){"ogg"==c&&(b+="_ogg");if(!a.checkPlugin(!0))return a.defaultSoundInstance;b=a.getSrcFromId(b);b=a.activePlugin.create(b);b.mute(a.muted);a.playInstance(b,
i,e,g,k,d,f)||b.playFailed();return b};a.playInstance=function(b,c,e,g,d,f,h){c=c||a.INTERRUPT_NONE;null==e&&(e=0);null==g&&(g=0);null==d&&(d=0);null==f&&(f=1);null==h&&(h=0);if(0==e){if(!a.beginPlaying(b,c,g,d,f,h))return!1}else setTimeout(function(){a.beginPlaying(b,c,g,d,f,h)},e);this.instances.push(b);this.instanceHash[b.uniqueId]=b;return!0};a.beginPlaying=function(b,a,c,g,d,h){return!f.add(b,a)?!1:!b.beginPlaying(c,g,d,h)?(this.instances.splice(this.instances.indexOf(b),1),delete this.instanceHash[b.uniqueId],
!1):!0};a.checkPlugin=function(b){return null==a.activePlugin&&(b&&!a.pluginsRegistered&&a.registerPlugin(a.HTMLAudioPlugin),null==a.activePlugin)?!1:!0};a.getSrcFromId=function(b){return null==a.idHash||null==a.idHash[b]?b:a.idHash[b]};a.setVolume=function(b,c){if(null==Number(b))return!1;b=Math.max(0,Math.min(1,b));return a.tellAllInstances("setVolume",c,b)};a.getMasterVolume=function(){return a.masterVolume};a.setMasterVolume=function(b){a.masterVolume=b;return a.tellAllInstances("setMasterVolume",
null,b)};a.setMute=function(b){this.muted=b;return a.tellAllInstances("mute",null,b)};a.pause=function(b){return a.tellAllInstances("pause",b)};a.resume=function(b){return a.tellAllInstances("resume",b)};a.stop=function(b){return a.tellAllInstances("stop",b)};a.getInstanceById=function(b){return this.instanceHash[b]};a.playFinished=function(b){f.remove(b);this.instances.splice(this.instances.indexOf(b),1)};a.tellAllInstances=function(b,a,c){if(null==this.activePlugin)return!1;for(var a=this.getSrcFromId(a),
g=this.instances.length-1;0<=g;g--){var d=this.instances[g];if(!(null!=a&&d.src!=a))switch(b){case "pause":d.pause();break;case "resume":d.resume();break;case "setVolume":d.setVolume(c);break;case "setMasterVolume":d.setMasterVolume(c);break;case "mute":d.mute(c);break;case "stop":d.stop();break;case "setPan":d.setPan(c)}}return!0};a.proxy=function(b,a){return function(){return b.apply(a,arguments)}};h.SoundJS=a;f.channels={};f.create=function(b,a){var c=f.get(b);null==c?f.channels[b]=new f(b,a):
c.max+=a};f.add=function(b,a){var c=f.get(b.src);return null==c?!1:c.add(b,a)};f.remove=function(a){var c=f.get(a.src);if(null==c)return!1;c.remove(a);return!0};f.get=function(a){return f.channels[a]};f.prototype={src:null,max:null,length:0,init:function(a,c){this.src=a;this.max=c||1;this.instances=[]},get:function(a){return this.instances[a]},add:function(a,c){if(!this.getSlot(c,a))return!1;this.instances.push(a);this.length++;return!0},remove:function(a){a=this.instances.indexOf(a);if(-1==a)return!1;
this.instances.splice(a,1);this.length--;return!0},getSlot:function(b){for(var c,e,d=0,f=this.max||100;d<f;d++){c=this.get(d);if(null==c)return!0;if(b!=a.INTERRUPT_NONE)if(0==d)e=c;else if(c.playState==a.PLAY_FINISHED||c==a.PLAY_INTERRUPTED||c==a.PLAY_FAILED)e=c;else if(b==a.INTERRUPT_EARLY&&c.getPosition()<e.getPosition()||b==a.INTERRUPT_LATE&&c.getPosition()>e.getPosition())e=c}return null!=e?(e.interrupt(),this.remove(e),!0):!1},toString:function(){return"[SoundJS SoundChannel]"}};a.defaultSoundInstance=
new function(){this.pause=this.resume=this.play=this.beginPlaying=this.cleanUp=this.interrupt=this.stop=this.setMasterVolume=this.setVolume=this.mute=this.setPan=this.getPosition=this.setPosition=this.toString=function(){return!1};this.getVolume=this.getPan=this.getDuration=function(){return 0};this.playState=a.PLAY_FAILED};d.init=function(){var a=navigator.userAgent;d.isFirefox=-1<a.indexOf("Firefox");d.isOpera=null!=h.opera;d.isIOS=-1<a.indexOf("iPod")||-1<a.indexOf("iPhone")||-1<a.indexOf("iPad");
d.isAdobeAIR=-1<a.indexOf("AdobeAIR")||h.navigator.isAIR;d.isAndroid=-1<a.indexOf("Android")};d.init();a.BrowserDetect=d})(window);
(function(h){function a(){this.init()}function f(a){this.init(a)}function d(a){this.init(a)}a.MAX_INSTANCES=30;a.capabilities=null;a.lastId=0;a.AUDIO_READY="canplaythrough";a.AUDIO_ENDED="ended";a.AUDIO_ERROR="error";a.AUDIO_STALLED="stalled";a.fillChannels=!1;a.isSupported=function(){if(SoundJS.BrowserDetect.isAdobeAIR&&SoundJS.BrowserDetect.isAndroid)return!1;a.generateCapabilities();if(a.capabilities.mp3||a.capabilities.ogg||a.capabilities.mpeg||a.capabilities.wav){var c=a.tag;return!(null==c||
null==c.canPlayType)}return!1};a.generateCapabilities=function(){if(null==a.capabilities){var c=a.tag=document.createElement("audio");a.capabilities={panning:!1,volume:!0,mp3:"no"!=c.canPlayType("audio/mp3")&&""!=c.canPlayType("audio/mp3")||"no"!=c.canPlayType("audio/mpeg")&&""!=c.canPlayType("audio/mpeg"),ogg:"no"!=c.canPlayType("audio/ogg")&&""!=c.canPlayType("audio/ogg"),mpeg:"no"!=c.canPlayType("audio/mpeg")&&""!=c.canPlayType("audio/mpeg"),wav:"no"!=c.canPlayType("audio/wav")&&""!=c.canPlayType("audio/wav"),
channels:a.MAX_INSTANCES}}};a.prototype={capabilities:null,FT:0.001,channels:null,init:function(){this.capabilities=a.capabilities;this.channels={}},register:function(a,b){for(var f=d.get(a),e,g=0,h=b||1;g<h;g++)e=this.createTag(a),f.add(e);return{tag:e}},createTag:function(a){var b=document.createElement("audio");b.preload=!1;b.src=a;return b},create:function(a){a=new f(a);a.owner=this;return a},toString:function(){return"[HTMLAudioPlugin]"}};h.SoundJS.HTMLAudioPlugin=a;f.prototype={src:null,uniqueId:-1,
playState:null,owner:null,loaded:!1,lastInterrupt:SoundJS.INTERRUPT_NONE,offset:0,delay:0,volume:1,pan:0,remainingLoops:0,delayTimeout:-1,tag:null,muted:!1,paused:!1,onComplete:null,onLoop:null,onReady:null,onPlayFailed:null,onPlayInterrupted:null,endedHandler:null,readyHandler:null,stalledHandler:null,init:function(c){this.uniqueId=a.lastId++;this.src=c;this.endedHandler=SoundJS.proxy(this.handleSoundComplete,this);this.readyHandler=SoundJS.proxy(this.handleSoundReady,this);this.stalledHandler=SoundJS.proxy(this.handleSoundStalled,
this)},cleanUp:function(){var c=this.tag;if(null!=c){c.pause();try{c.currentTime=0}catch(b){}c.removeEventListener(a.AUDIO_ENDED,this.endedHandler,!1);c.removeEventListener(a.AUDIO_READY,this.readyHandler,!1);d.setInstance(this.src,c);this.tag=null}SoundJS.playFinished(this)},interrupt:function(){if(null!=this.tag){this.playState=SoundJS.PLAY_INTERRUPTED;if(this.onPlayInterrupted)this.onPlayInterrupted(this);this.cleanUp();this.paused=!1}},play:function(a,b,d,e,g,f){this.cleanUp();SoundJS.playInstance(this,
a,b,d,e,g,f)},beginPlaying:function(c,b,f){var e=this.tag=d.getInstance(this.src);if(null==e)return this.playFailed(),-1;e.addEventListener(a.AUDIO_ENDED,this.endedHandler,!1);this.offset=c;this.volume=f;this.updateVolume();this.remainingLoops=b;4!==e.readyState?(e.addEventListener(a.AUDIO_READY,this.readyHandler,!1),e.addEventListener(a.AUDIO_STALLED,this.stalledHandler,!1),e.load()):this.handleSoundReady(null);return 1},handleSoundStalled:function(){if(null!=this.onPlayFailed)this.onPlayFailed(this);
this.cleanUp()},handleSoundReady:function(){this.playState=SoundJS.PLAY_SUCCEEDED;this.paused=!1;this.tag.removeEventListener(a.AUDIO_READY,this.readyHandler,!1);this.offset>=this.getDuration()?this.playFailed():(this.tag.currentTime=0.001*this.offset,this.tag.play())},pause:function(){this.paused=!0;return null!=this.tag?(this.tag.pause(),!1):!0},resume:function(){this.paused=!1;return null!=this.tag?(this.tag.play(),!1):!0},stop:function(){this.pause();this.playState=SoundJS.PLAY_FINISHED;this.cleanUp();
return!0},setMasterVolume:function(){this.updateVolume();return!0},setVolume:function(a){this.volume=a;this.updateVolume();return!0},updateVolume:function(){return null!=this.tag?(this.tag.volume=this.muted?0:this.volume*SoundJS.masterVolume,!0):!1},getVolume:function(){return this.volume},mute:function(a){this.muted=a;this.updateVolume();return!0},setPan:function(){return!1},getPan:function(){return 0},getPosition:function(){return null==this.tag?0:1E3*this.tag.currentTime},setPosition:function(a){if(null==
this.tag)return!1;try{this.tag.currentTime=0.001*a}catch(b){return!1}return!0},getDuration:function(){return null==this.tag?0:1E3*this.tag.duration},handleSoundComplete:function(){if(0!=this.remainingLoops){this.remainingLoops--;try{this.tag.currentTime=0}catch(a){}this.tag.play();if(null!=this.onLoop)this.onLoop(this)}else{this.playState=SoundJS.PLAY_FINISHED;if(null!=this.onComplete)this.onComplete(this);this.cleanUp()}},playFailed:function(){this.playState=SoundJS.PLAY_FAILED;if(null!=this.onPlayFailed)this.onPlayFailed(this);
this.cleanUp()},toString:function(){return"[HTMLAudio SoundInstance]"}};d.channels={};d.get=function(a){var b=d.channels[a];null==b&&(b=d.channels[a]=new d(a));return b};d.getInstance=function(a){a=d.channels[a];return null==a?null:a.get()};d.setInstance=function(a,b){var f=d.channels[a];return null==f?null:f.set(b)};d.prototype={src:null,length:0,available:0,tags:null,container:null,init:function(a){this.src=a;this.tags=[];this.container=document.createElement("div");this.container.style.width="0px";
this.container.style.height="0px";document.body.appendChild(this.container)},add:function(a){this.tags.push(a);this.length++;this.available=this.tags.length},get:function(){if(0==this.tags.length)return null;this.available=this.tags.length;var a=this.tags.pop();null==a.parentNode&&this.container.appendChild(a);return a},set:function(a){-1==this.tags.indexOf(a)&&this.tags.push(a);this.available=this.tags.length},toString:function(){return"[HTMLAudioPlugin TagChannel]"}}})(window);
(function(h){function a(){this.init()}function f(a,b){this.init(a,b)}function d(a,b,d,e){this.init(a,b,d,e)}a.capabilities=null;a.BASE_PATH="src/soundjs";a.lastId=0;a.preloadId=0;a.isSupported=function(){return SoundJS.BrowserDetect.isAdobeAIR&&SoundJS.BrowserDetect.isAndroid};a.generateCapabilities=function(){return null!=a.capabilities?a.capabilities:a.capabilities={panning:!0,volume:!0,mp3:!0,ogg:!0,mpeg:!0,wav:!0,channels:255}};a.prototype={CONTAINER_ID:"flashAudioContainer",capabilities:null,
container:null,externalContainer:null,flashReady:!1,externalPlayerSoundInstances:null,externalPlayerPreloadInstances:null,queuedInstances:null,init:function(){this.capabilities=a.generateCapabilities();this.externalPlayerSoundInstances={};this.externalPlayerPreloadInstances={};this.queuedInstances=[]},handleTimeout:function(){},register:function(c){var b="p"+a.preloadId++;return new d(c,this.externalContainer,this,b)},create:function(a){try{var b=new f(a,this.externalContainer);b.owner=this;return b}catch(d){}return null},
registerSoundInstance:function(a,b){this.externalPlayerSoundInstances[a]=b},unregisterSoundInstance:function(a){delete this.externalPlayerSoundInstances[a]},handleSoundEvent:function(a,b){var d=this.externalPlayerSoundInstances[a];if(null!=d){for(var e=[],f=2,h=arguments.length;f<h;f++)e.push(arguments[f]);try{if(0==e.length)d[b]();else d[b].apply(d,e)}catch(j){}}},handleEvent:function(){},handleErrorEvent:function(){},toString:function(){return"[ExternalPlugin]"}};h.SoundJS.ExternalPlugin=a;f.prototype=
{src:null,uniqueId:-1,capabilities:null,externalContainer:null,playerId:null,loop:0,volume:1,pan:0,muted:!1,paused:!1,onComplete:null,onLoop:null,onReady:null,onPlayFailed:null,onPlayInterrupted:null,init:function(a){this.playerId=h.soundJsExternalRegister(a);this.src=a;this.externalPlayer=h},initialize:function(a){this.externalContainer=a},interrupt:function(){this.playState=SoundJS.PLAY_INTERRUPTED;if(null!=this.onPlayInterrupted)this.onPlayInterrupted(this);this.cleanUp()},cleanUp:function(){this.owner.unregisterSoundInstance(this.playerId);
SoundJS.playFinished(this)},play:function(a,b,d,e,f,h,j){SoundJS.playInstance(this,a,b,d,e,f,h,j)},beginPlaying:function(a,b){this.loop=b;this.paused=!1;this.externalPlayer.soundJsExternalPlay(this.playerId);this.playState=SoundJS.PLAY_SUCCEEDED;this.owner.registerSoundInstance(this.playerId,this);return!0},pause:function(){this.paused=!0;this.externalPlayer.soundJsExternalPause(this.playerId)},resume:function(){this.paused=!1;this.externalPlayer.soundJsExternalResume(this.playerId)},stop:function(){this.playState=
SoundJS.PLAY_FINISHED;this.paused=!1;this.externalPlayer.soundJsExternalStop(this.playerId);this.cleanUp();return!0},setVolume:function(a){this.volume=a},getVolume:function(){return this.volume},mute:function(a){this.muted=a},getPan:function(){return this.pan},setPan:function(a){this.pan=a},getPosition:function(){return 0},setPosition:function(){},getDuration:function(){},handleSoundFinished:function(){this.playState=SoundJS.PLAY_FINISHED;if(null!=this.onComplete)this.onComplete(this);this.cleanUp()},
handleLoop:function(){if(null!=this.onLoop)this.onLoop(this)},toString:function(){return"[ExternalPlugin SoundInstance]"}};d.prototype={externalContainer:null,src:null,tag:null,playerId:null,progress:1,readyState:4,loading:!1,preloadId:null,owner:null,onload:null,onprogress:null,onError:null,init:function(a,b,d,e){this.src=a;this.externalContainer=b;this.owner=d;this.preloadId=e;this.tag=this},initialize:function(){},load:function(){return!1},handleProgress:function(a,b){this.progress=a/b;if(null!=
this.onprogress)this.onprogress({loaded:a,total:b,progress:this.progress})},handleComplete:function(){this.progress=1;this.readyState=4;if(null!=this.onload)this.onload()},handleError:function(a){if(null!=this.onerror)this.onerror(a)},toString:function(){return"[ExternalPlugin SoundLoader]"}}})(window);
